/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.view;

import javax.swing.JMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.view.Importer;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterComponent;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterModel;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import pojos.DataObject;

public class ImporterFactory
implements ChangeListener {
    private static final String NAME = "FS importer";
    private static final String MENU_NAME = "FS importer";
    private static final ImporterFactory singleton = new ImporterFactory();
    private Importer importer;
    private boolean isAttached = false;
    private JMenu windowMenu = new JMenu("FS importer");

    public static Importer getImporter() {
        ImporterModel model = new ImporterModel();
        return singleton.getImporter(model);
    }

    public static Importer getImporter(DataObject container) {
        ImporterModel model = new ImporterModel();
        model.setContainer(container);
        return singleton.getImporter(model);
    }

    static JMenu getWindowMenu() {
        return ImporterFactory.singleton.windowMenu;
    }

    static boolean isWindowMenuAttachedToTaskBar() {
        return ImporterFactory.singleton.isAttached;
    }

    static void attachWindowMenuToTaskBar() {
        if (ImporterFactory.isWindowMenuAttachedToTaskBar()) {
            return;
        }
        TaskBar tb = ImporterAgent.getRegistry().getTaskBar();
        tb.addToMenu(0, ImporterFactory.singleton.windowMenu);
        ImporterFactory.singleton.isAttached = true;
    }

    private ImporterFactory() {
    }

    private Importer getImporter(ImporterModel model) {
        if (this.importer != null) {
            return this.importer;
        }
        ImporterComponent comp = new ImporterComponent(model);
        model.initialize(comp);
        this.importer = comp;
        return this.importer;
    }

    public void stateChanged(ChangeEvent ce) {
        ImporterComponent comp = (ImporterComponent)ce.getSource();
        if (comp.getState() == 3) {
            this.importer = null;
        }
    }
}

