/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.view;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.chooser.ImporterChooserDialog;
import org.openmicroscopy.shoola.agents.fsimporter.view.Importer;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterUI;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class ImporterControl
implements PropertyChangeListener {
    private Importer model;
    private ImporterUI view;
    private ImporterChooserDialog chooser;

    ImporterControl(Importer model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
    }

    void setDialogOnScreen() {
        if (this.chooser == null) {
            Registry reg = ImporterAgent.getRegistry();
            this.chooser = new ImporterChooserDialog(this.view, reg.getImageService().getFSFileSystemView());
            this.chooser.addPropertyChangeListener(this);
            this.chooser.pack();
        }
        UIUtilities.centerAndShow(this.chooser);
    }

    void initialize(ImporterUI view) {
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.view = view;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("import".equals(name)) {
            File[] data = (File[])evt.getNewValue();
            this.model.importData(data);
        } else if ("monitorFS".equals(name)) {
            File dir = (File)evt.getNewValue();
            this.model.monitorDirectory(dir);
        }
    }
}

