/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.view;

import java.io.File;
import org.openmicroscopy.shoola.agents.fsimporter.ImporterAgent;
import org.openmicroscopy.shoola.agents.fsimporter.view.Importer;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterControl;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterModel;
import org.openmicroscopy.shoola.agents.fsimporter.view.ImporterUI;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;

class ImporterComponent
extends AbstractComponent
implements Importer {
    private ImporterModel model;
    private ImporterControl controller;
    private ImporterUI view;

    ImporterComponent(ImporterModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new ImporterControl(this);
        this.view = new ImporterUI();
    }

    void initialize() {
        this.controller.initialize(this.view);
        this.view.initialize(this.model, this.controller);
    }

    public void activate() {
        switch (this.model.getState()) {
            case 1: {
                this.controller.setDialogOnScreen();
                this.model.setState(2);
                break;
            }
            case 3: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
        }
    }

    public void discard() {
        if (this.model.getState() == 3) {
            this.model.discard();
        }
    }

    public int getState() {
        return this.model.getState();
    }

    public void cancel() {
        this.model.cancel();
    }

    public void importData(File[] data) {
        if (this.model.getState() != 2) {
            return;
        }
        if (data == null || data.length == 0) {
            UserNotifier un = ImporterAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Import", "No images to import.");
            return;
        }
        this.model.fireImportData(data);
        this.fireStateChange();
    }

    public void monitorDirectory(File dir) {
        if (this.model.getState() != 2) {
            return;
        }
        if (dir == null) {
            UserNotifier un = ImporterAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Import", "No directory to monitor.");
            return;
        }
        this.model.fireMonitorDirectory(dir);
        this.fireStateChange();
    }
}

