/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.fsimporter.chooser;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.JFileChooser;
import javax.swing.JTextField;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileSystemView;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ImporterChooser
extends JFileChooser {
    private JTextField nameArea;
    private FileSystemView fsv;

    private void initComponents() {
        this.nameArea = (JTextField)UIUtilities.findComponent(this, JTextField.class);
        if (this.nameArea != null) {
            // empty if block
        }
    }

    private void initFilters(List<FileFilter> filters) {
        if (filters != null) {
            ViewerSorter sorter = new ViewerSorter();
            List l = sorter.sort(filters);
            Iterator i = l.iterator();
            while (i.hasNext()) {
                this.addChoosableFileFilter((FileFilter)i.next());
            }
        }
    }

    private void initialize(List<FileFilter> filters) {
        this.initComponents();
        this.initFilters(filters);
        this.setControlButtonsAreShown(false);
        File f = this.getFileSystemView().getDefaultDirectory();
        if (f != null) {
            this.setSelectedFile(f);
        }
    }

    ImporterChooser(FileSystemView fsv, List<FileFilter> filters) {
        this.fsv = fsv;
        this.initialize(filters);
    }

    File getFSDefaultDirectory() {
        return this.fsv.getDefaultDirectory();
    }

    ImporterChooser(List<FileFilter> filters) {
        this.initialize(filters);
    }

    File getSelectedDirectory() {
        File f = this.getSelectedFile();
        if (f.isDirectory()) {
            return f;
        }
        return null;
    }
}

