/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.events.iviewer;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.List;
import java.util.Map;
import org.openmicroscopy.shoola.env.event.RequestEvent;
import pojos.ChannelData;
import pojos.PixelsData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MeasurementTool
extends RequestEvent {
    private PixelsData pixels;
    private long imageID;
    private String name;
    private int defaultZ;
    private int defaultT;
    private Map activeChannels;
    private double magnification;
    private Rectangle requesterBounds;
    private BufferedImage thumbnail;
    private BufferedImage renderedImage;
    private List<ChannelData> channelData;

    public MeasurementTool(long imageID, PixelsData pixels, String name, int defaultZ, int defaultT, Map activeChannels, double magnification, Rectangle bounds, List<ChannelData> channelData) {
        if (pixels == null) {
            throw new IllegalArgumentException("Pixels set not valid.");
        }
        if (imageID < 0L) {
            throw new IllegalArgumentException("Image ID not valid.");
        }
        if (channelData == null || channelData.size() == 0) {
            throw new IllegalArgumentException("Channel data not valid.");
        }
        this.channelData = channelData;
        this.pixels = pixels;
        this.imageID = imageID;
        this.name = name;
        this.defaultT = defaultT;
        this.defaultZ = defaultZ;
        this.activeChannels = activeChannels;
        this.magnification = magnification;
        this.requesterBounds = bounds;
    }

    public void setThumbnail(BufferedImage thumbnail) {
        this.thumbnail = thumbnail;
    }

    public void setRenderedImage(BufferedImage renderedImage) {
        this.renderedImage = renderedImage;
    }

    public BufferedImage getRenderedImage() {
        return this.renderedImage;
    }

    public BufferedImage getThumbnail() {
        return this.thumbnail;
    }

    public long getImageID() {
        return this.imageID;
    }

    public String getName() {
        return this.name;
    }

    public PixelsData getPixels() {
        return this.pixels;
    }

    public Rectangle getRequesterBounds() {
        return this.requesterBounds;
    }

    public int getDefaultZ() {
        return this.defaultZ;
    }

    public int getDefaultT() {
        return this.defaultT;
    }

    public double getMagnification() {
        return this.magnification;
    }

    public Map getActiveChannels() {
        return this.activeChannels;
    }

    public List<ChannelData> getChannelData() {
        return this.channelData;
    }
}

