/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.view;

import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.actions.ActivationAction;
import org.openmicroscopy.shoola.agents.editor.view.Editor;
import org.openmicroscopy.shoola.agents.editor.view.EditorComponent;
import org.openmicroscopy.shoola.agents.editor.view.EditorModel;
import org.openmicroscopy.shoola.env.data.events.ExitApplication;
import org.openmicroscopy.shoola.env.event.EventBus;
import org.openmicroscopy.shoola.env.ui.TaskBar;
import pojos.DataObject;
import pojos.FileAnnotationData;

public class EditorFactory
implements ChangeListener {
    public static final String BLANK_MODEL = "No File Open";
    private static final EditorFactory singleton = new EditorFactory();
    private Set<Editor> editors = new HashSet<Editor>();
    private JMenu windowMenu = new JMenu("Editors");
    private Object copiedData;
    private boolean isAttached = false;

    public static Editor getEditor(FileAnnotationData fileAnnotation) {
        EditorModel model = new EditorModel(fileAnnotation);
        return singleton.getEditor(model);
    }

    public static Editor getEditor(long fileID) {
        EditorModel model = new EditorModel(fileID);
        return singleton.getEditor(model);
    }

    public static Editor getEditor(DataObject parent, String name, int type) {
        EditorModel model = new EditorModel(parent, name, type);
        Editor editor = singleton.getEditor(model);
        if (editor != null) {
            ((EditorComponent)editor).setNewExperiment();
            editor.setStatus("", true);
        }
        return editor;
    }

    public static Editor getEditor(File file) {
        if (file == null) {
            return EditorFactory.getEditor();
        }
        EditorModel model = new EditorModel(file);
        return singleton.getEditor(model);
    }

    public static Editor getEditor() {
        if (EditorFactory.singleton.editors.isEmpty()) {
            return EditorFactory.getNewBlankEditor();
        }
        Editor e = EditorFactory.singleton.editors.iterator().next();
        if (e == null) {
            return e;
        }
        EditorModel model = ((EditorComponent)e).getModel();
        return singleton.getEditor(model);
    }

    public static void setCopiedData(Object copiedData) {
        EditorFactory.singleton.copiedData = copiedData;
    }

    public static Object getCopiedData() {
        return EditorFactory.singleton.copiedData;
    }

    public static Editor getNewBlankEditor() {
        EditorModel model = new EditorModel();
        Editor editor = singleton.getEditor(model);
        if (editor != null) {
            editor.setStatus("", true);
        }
        return editor;
    }

    public static int getEditorCount() {
        return EditorFactory.singleton.editors.size();
    }

    static void register(JMenu menu) {
        if (menu == null) {
            return;
        }
        Iterator<Editor> i = EditorFactory.singleton.editors.iterator();
        menu.removeAll();
        while (i.hasNext()) {
            menu.add(new JMenuItem(new ActivationAction(i.next())));
        }
    }

    static JMenu getWindowMenu() {
        return EditorFactory.singleton.windowMenu;
    }

    static void attachWindowMenuToTaskBar() {
        if (EditorFactory.singleton.isAttached) {
            return;
        }
        TaskBar tb = EditorAgent.getRegistry().getTaskBar();
        tb.addToMenu(0, EditorFactory.singleton.windowMenu);
        EditorFactory.singleton.isAttached = true;
    }

    private EditorFactory() {
    }

    private Editor getEditor(EditorModel model) {
        for (EditorComponent editorComponent : this.editors) {
            EditorModel m = editorComponent.getModel();
            if (m.getAnnotationId() == model.getAnnotationId()) {
                if (m.getFileID() > 0L) {
                    return editorComponent;
                }
                if (m.getFileName().equals(model.getFileName())) {
                    return editorComponent;
                }
            }
            if (!m.getFileName().equals(model.getFileName())) continue;
            return editorComponent;
        }
        EditorComponent editorComponent = new EditorComponent(model);
        editorComponent.initialize();
        editorComponent.addChangeListener(this);
        this.editors.add(editorComponent);
        return editorComponent;
    }

    public void stateChanged(ChangeEvent ce) {
        EditorComponent comp = (EditorComponent)ce.getSource();
        if (comp.getState() == 4) {
            this.editors.remove(comp);
        }
        if (this.editors.size() == 0) {
            TaskBar tb = EditorAgent.getRegistry().getTaskBar();
            tb.removeFromMenu(0, this.windowMenu);
            this.isAttached = false;
            if (!EditorAgent.isServerAvailable()) {
                EventBus bus = EditorAgent.getRegistry().getEventBus();
                bus.post(new ExitApplication(false));
            }
        }
    }
}

