/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.view;

import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JMenu;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuKeyEvent;
import javax.swing.event.MenuKeyListener;
import javax.swing.event.MenuListener;
import org.openmicroscopy.shoola.agents.editor.actions.CloseEditorAction;
import org.openmicroscopy.shoola.agents.editor.actions.EditorAction;
import org.openmicroscopy.shoola.agents.editor.actions.NewBlankFileAction;
import org.openmicroscopy.shoola.agents.editor.actions.OpenLocalFileAction;
import org.openmicroscopy.shoola.agents.editor.actions.OpenWwwFileAction;
import org.openmicroscopy.shoola.agents.editor.actions.SaveFileAction;
import org.openmicroscopy.shoola.agents.editor.actions.SaveFileLocallyAction;
import org.openmicroscopy.shoola.agents.editor.actions.SaveFileServerAction;
import org.openmicroscopy.shoola.agents.editor.view.Editor;
import org.openmicroscopy.shoola.agents.editor.view.EditorFactory;
import org.openmicroscopy.shoola.agents.editor.view.EditorUI;

class EditorControl
implements ChangeListener {
    static final Integer CLOSE_EDITOR = 1;
    static final Integer OPEN_LOCAL_FILE = 2;
    static final Integer SAVE_FILE_LOCALLY = 3;
    static final Integer NEW_BLANK_FILE = 4;
    static final Integer SAVE_FILE = 5;
    static final Integer OPEN_WWW_FILE = 6;
    static final Integer SAVE_FILE_SERVER = 7;
    private Editor model;
    private EditorUI view;
    private Map<Integer, EditorAction> actionsMap;

    private void createActions() {
        this.actionsMap.put(CLOSE_EDITOR, new CloseEditorAction(this.model));
        this.actionsMap.put(OPEN_LOCAL_FILE, new OpenLocalFileAction(this.model));
        this.actionsMap.put(SAVE_FILE_LOCALLY, new SaveFileLocallyAction(this.model));
        this.actionsMap.put(NEW_BLANK_FILE, new NewBlankFileAction(this.model));
        this.actionsMap.put(SAVE_FILE, new SaveFileAction(this.model));
        this.actionsMap.put(OPEN_WWW_FILE, new OpenWwwFileAction(this.model));
        this.actionsMap.put(SAVE_FILE_SERVER, new SaveFileServerAction(this.model));
    }

    private void createWindowsMenuItems(JMenu menu) {
        EditorFactory.register(menu);
    }

    private void attachListeners() {
        this.model.addChangeListener(this);
        JMenu menu = EditorFactory.getWindowMenu();
        menu.addMenuListener(new MenuListener(){

            public void menuSelected(MenuEvent e) {
                Object source = e.getSource();
                if (source instanceof JMenu) {
                    EditorControl.this.createWindowsMenuItems((JMenu)source);
                }
            }

            public void menuCanceled(MenuEvent e) {
            }

            public void menuDeselected(MenuEvent e) {
            }
        });
        menu.addMenuKeyListener(new MenuKeyListener(){

            public void menuKeyReleased(MenuKeyEvent e) {
                Object source = e.getSource();
                if (source instanceof JMenu) {
                    EditorControl.this.createWindowsMenuItems((JMenu)source);
                }
            }

            public void menuKeyPressed(MenuKeyEvent e) {
            }

            public void menuKeyTyped(MenuKeyEvent e) {
            }
        });
        this.view.setDefaultCloseOperation(0);
        this.view.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                EditorControl.this.model.discard();
            }
        });
    }

    EditorControl(Editor model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.actionsMap = new HashMap<Integer, EditorAction>();
    }

    void initialize(EditorUI view) {
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.view = view;
        this.attachListeners();
        this.createActions();
        EditorFactory.attachWindowMenuToTaskBar();
    }

    EditorAction getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    public void stateChanged(ChangeEvent e) {
        int state = this.model.getState();
        switch (state) {
            case 2: {
                this.model.setStatus("Loading...", false);
                break;
            }
            case 5: {
                this.model.setStatus("Saving...", false);
                break;
            }
            case 3: {
                this.model.setStatus("", true);
                break;
            }
            case 1: {
                this.model.setStatus("", true);
                break;
            }
            case 4: {
                this.view.close();
            }
        }
    }
}

