/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.view;

import java.beans.PropertyChangeListener;
import java.io.File;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.actions.SaveNewCmd;
import org.openmicroscopy.shoola.agents.editor.browser.Browser;
import org.openmicroscopy.shoola.agents.editor.view.Editor;
import org.openmicroscopy.shoola.agents.editor.view.EditorControl;
import org.openmicroscopy.shoola.agents.editor.view.EditorFactory;
import org.openmicroscopy.shoola.agents.editor.view.EditorModel;
import org.openmicroscopy.shoola.agents.editor.view.EditorUI;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import pojos.FileAnnotationData;

class EditorComponent
extends AbstractComponent
implements Editor {
    private EditorModel model;
    private EditorControl controller;
    private EditorUI view;

    EditorComponent(EditorModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.controller = new EditorControl(this);
        this.view = new EditorUI(model.getFileName());
    }

    void initialize() {
        this.model.initialize(this);
        this.controller.initialize(this.view);
        this.view.initialize(this.controller, this.model);
    }

    EditorModel getModel() {
        return this.model;
    }

    void setNewExperiment() {
        this.model.setBlankFile(this.model.getFileName());
        this.view.displayFile();
        this.model.updateNameSpace();
        this.fireStateChange();
    }

    public void activate() {
        int state = this.model.getState();
        switch (state) {
            case 1: {
                if (this.model.getFileID() != 0L) {
                    this.model.fireFileLoading();
                    this.fireStateChange();
                    break;
                }
                if (this.view == null) break;
                this.view.setVisible(true);
                break;
            }
            case 4: {
                throw new IllegalStateException("This method can't be invoked in the DISCARDED state.");
            }
            default: {
                if (this.view == null) break;
                this.view.setVisible(true);
            }
        }
    }

    public boolean hasDataToSave() {
        return this.model.hasDataToSave();
    }

    public void discard() {
        if (this.model.hasDataToSave()) {
            MessageBox msg = new MessageBox(this.view, "Save Data", "Before closing the Editor, do you want to save?");
            msg.addCancelButton();
            int option = msg.centerMsgBox();
            if (option == 1) {
                boolean saved = this.saveCurrentFile();
                if (saved) {
                    this.model.discard();
                } else {
                    SaveNewCmd save = new SaveNewCmd(this);
                    save.execute();
                }
            } else if (option == 0) {
                this.model.discard();
            }
        } else {
            this.model.discard();
        }
        this.fireStateChange();
    }

    public int getState() {
        return this.model.getState();
    }

    public void setStatus(String description, boolean hide) {
        this.view.setStatus(description, hide);
    }

    public void cancel() {
        if (this.model.getState() == 4) {
            return;
        }
        this.model.cancel();
    }

    public void setFileToEdit(FileAnnotationData fa, File file) {
        if (this.model.getState() != 2 && this.model.getState() != 1) {
            throw new IllegalStateException("This method should only be invoked in the LOADING or NEW states.");
        }
        if (fa != null) {
            this.model.setFileAnnotationData(fa);
        }
        if (this.model.setFileToEdit(file)) {
            this.model.updateNameSpace();
            this.view.setTitle(this.model.getFileName());
            this.view.displayFile();
            this.model.getBrowser().setId(this.model.getAnnotationId());
            if (!this.view.isVisible()) {
                this.view.setVisible(true);
            }
        }
        this.fireStateChange();
    }

    public String getEditorTitle() {
        if (this.model.getState() == 4) {
            return "";
        }
        return this.model.getFileName();
    }

    public void openLocalFile(File file) {
        EditorAgent.openLocalFile(file);
    }

    public void newBlankFile() {
        Editor editor = EditorFactory.getNewBlankEditor();
        if (editor != null) {
            editor.setBlankFile();
            editor.activate();
        }
    }

    public void setBlankFile() {
        this.model.setBlankFile(null);
        this.view.displayFile();
        this.fireStateChange();
    }

    public boolean saveCurrentFile() {
        MessageBox msg;
        int option;
        String savedNamespace = this.model.getNameSpace();
        if ("openmicroscopy.org/omero/editor/protocol".equals(savedNamespace) && this.model.getBrowser().isModelExperiment() && (option = (msg = new MessageBox(this.view, "Save Experiment?", "Overwrite 'Protocol' with 'Experiment'?\n \n(Answer 'No' to 'Save As' a new file)")).centerMsgBox()) != 1) {
            return false;
        }
        long fileID = this.model.getFileID();
        if (fileID <= 0L) {
            boolean b = this.model.saveLocalFile();
            if (b) {
                this.model.updateNameSpace();
                UserNotifier un = EditorAgent.getRegistry().getUserNotifier();
                un.notifyInfo("File Saved", "The File has been saved locally.");
            }
            return b;
        }
        File toEdit = this.model.getFileToEdit();
        if (toEdit == null) {
            String fileName = this.model.getFileName();
            toEdit = new File(fileName);
        }
        this.model.fireFileSaving(toEdit);
        this.model.updateNameSpace();
        return true;
    }

    public boolean saveFileLocally(File file) {
        if (this.model.saveFileAs(file)) {
            this.view.setTitle(this.model.getFileName());
            this.model.getBrowser().setId(this.model.getAnnotationId());
            return true;
        }
        return false;
    }

    public void saveFileServer(String fileName) {
        this.model.setFileAnnotationData(null);
        this.model.fireFileSaving(new File(fileName));
        this.fireStateChange();
    }

    public void onFileSave(FileAnnotationData data) {
        UserNotifier un = EditorAgent.getRegistry().getUserNotifier();
        String message = "An error occured while saving the file to the server.";
        if (data != null) {
            long id = data.getId();
            message = "The File has been saved to the server. \nID = " + id;
            this.model.setFileAnnotationData(data);
            this.model.getBrowser().setId(id);
        }
        un.notifyInfo("File Saved", message);
        this.model.setState(3);
        this.view.setTitle(this.model.getFileName());
        this.fireStateChange();
    }

    public void registerBrowserListener(PropertyChangeListener listener) {
        if (listener != null) {
            this.model.getBrowser().addPropertyChangeListener(listener);
        }
    }

    public void setEdited(boolean editable) {
        Browser browser = this.model.getBrowser();
        if (browser != null) {
            browser.setEdited(editable);
        }
    }

    public boolean isExperiment() {
        Browser browser = this.model.getBrowser();
        if (browser == null) {
            return false;
        }
        return browser.isModelExperiment();
    }
}

