/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.util;

import java.io.File;
import java.io.IOException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.util.roi.exception.ParsingException;
import org.w3c.dom.Document;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLMethods {
    public static Document readXMLtoDOM(File xmlFile) throws ParsingException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        Document document = null;
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            builder.setErrorHandler(new ErrorHandler(){

                public void fatalError(SAXParseException exception) throws SAXException {
                }

                public void error(SAXParseException e) throws SAXParseException {
                    throw e;
                }

                public void warning(SAXParseException err) throws SAXParseException {
                    System.out.println("** Warning, line " + err.getLineNumber() + ", uri " + err.getSystemId());
                    System.out.println("   " + err.getMessage());
                }
            });
            document = builder.parse(xmlFile);
        }
        catch (SAXException sxe) {
            throw new ParsingException(sxe.getMessage(), sxe);
        }
        catch (ParserConfigurationException pce) {
            EditorAgent.getRegistry().getUserNotifier().notifyError("Parser Confuguration Exception", "Parser with specified options can't be built.", pce);
        }
        catch (IOException ioe) {
            EditorAgent.getRegistry().getUserNotifier().notifyError("I/O error", "File could not be read", ioe);
        }
        return document;
    }
}

