/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import uk.ac.ebi.ook.web.services.Query;
import uk.ac.ebi.ook.web.services.QueryServiceLocator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OntologyLookUp {
    public static Map<String, String> getTermsByName(String name, String ontologyID) {
        boolean removeObsoleteTerms = false;
        HashMap map = null;
        try {
            QueryServiceLocator locator = new QueryServiceLocator();
            Query qs = locator.getOntologyQuery();
            map = qs.getTermsByName(name, ontologyID, false);
            if (removeObsoleteTerms) {
                ArrayList<String> obsoleteTermIds = new ArrayList<String>();
                for (String key : map.keySet()) {
                    if (!qs.isObsolete(key, ontologyID)) continue;
                    obsoleteTermIds.add(key);
                }
                for (String termId : obsoleteTermIds) {
                    map.remove(termId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return map;
    }

    public static Map<String, String> getTermMetadata(String termID, String ontologyID) {
        HashMap metaDataMap = null;
        try {
            QueryServiceLocator locator = new QueryServiceLocator();
            Query qs = locator.getOntologyQuery();
            metaDataMap = qs.getTermMetadata(termID, ontologyID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return metaDataMap;
    }

    public static Map<String, String> getTermParents(String termID, String ontologyID) {
        HashMap parentsMap = null;
        try {
            QueryServiceLocator locator = new QueryServiceLocator();
            Query qs = locator.getOntologyQuery();
            parentsMap = qs.getTermParents(termID, ontologyID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return parentsMap;
    }

    public static String getTermName(String termId, String ontologyID) {
        String termName = "";
        try {
            QueryServiceLocator locator = new QueryServiceLocator();
            Query qs = locator.getOntologyQuery();
            termName = qs.getTermById(termId, ontologyID);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return termName;
    }
}

