/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.util;

import java.io.File;
import java.util.StringTokenizer;

public class FilePathMethods {
    public static String getRelativePathFromAbsolutePath(File linkFromFile, String absolutePath) {
        return FilePathMethods.getRelativePathFromAbsolutePath(linkFromFile.getParent(), absolutePath);
    }

    public static String getRelativePathFromAbsolutePath(String linkFromDir, String absolutePath) {
        int commonDirsCount;
        if (linkFromDir == null) {
            throw new IllegalArgumentException("File must have valid file path");
        }
        String fileSeparator = File.separator;
        StringTokenizer st = new StringTokenizer(linkFromDir, fileSeparator);
        int tokens = st.countTokens();
        String[] editorFileDirectories = new String[tokens];
        for (int i = 0; i < editorFileDirectories.length; ++i) {
            editorFileDirectories[i] = st.nextToken();
        }
        st = new StringTokenizer(absolutePath, fileSeparator);
        tokens = st.countTokens();
        String[] imageFileDirectories = new String[tokens];
        for (int i = 0; i < imageFileDirectories.length; ++i) {
            imageFileDirectories[i] = st.nextToken();
        }
        for (commonDirsCount = 0; commonDirsCount < editorFileDirectories.length && commonDirsCount < imageFileDirectories.length && editorFileDirectories[commonDirsCount].equals(imageFileDirectories[commonDirsCount]); ++commonDirsCount) {
        }
        String relativeFilePath = "";
        for (int i = commonDirsCount; i < imageFileDirectories.length; ++i) {
            if (i > commonDirsCount) {
                relativeFilePath = relativeFilePath + File.separator;
            }
            relativeFilePath = relativeFilePath + imageFileDirectories[i];
        }
        int editorFileDirsRemaining = editorFileDirectories.length - commonDirsCount;
        for (int i = 0; i < editorFileDirsRemaining; ++i) {
            relativeFilePath = ".." + File.separator + relativeFilePath;
        }
        return relativeFilePath;
    }

    public static String getAbsolutePathFromRelativePath(File editorFile, String relativePath) {
        if (editorFile == null) {
            return null;
        }
        String editorDirectory = editorFile.getParent();
        if (editorDirectory == null) {
            throw new IllegalArgumentException("File must have valid file path");
        }
        StringTokenizer st = new StringTokenizer(editorDirectory, File.separator);
        int tokens = st.countTokens();
        String[] editorFileDirectories = new String[tokens];
        for (int i = 0; i < editorFileDirectories.length; ++i) {
            editorFileDirectories[i] = st.nextToken();
        }
        int filePathExtraDirs = 0;
        while (relativePath.startsWith("..")) {
            ++filePathExtraDirs;
            relativePath = relativePath.substring(3, relativePath.length());
        }
        String absoluteImagePath = "";
        int commonDirs = editorFileDirectories.length - filePathExtraDirs;
        for (int i = 0; i < commonDirs; ++i) {
            absoluteImagePath = absoluteImagePath.concat(File.separator + editorFileDirectories[i]);
        }
        absoluteImagePath = absoluteImagePath + File.separator + relativePath;
        return absoluteImagePath;
    }
}

