/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.uiComponents;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.IconManager;
import org.openmicroscopy.shoola.agents.editor.util.FileDownload;
import org.openmicroscopy.shoola.agents.editor.view.Editor;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.ui.BrowserLauncher;
import org.openmicroscopy.shoola.util.ui.TitlePanel;

public class UrlChooser
extends JPanel
implements ActionListener,
HyperlinkListener {
    private Editor model;
    protected JFrame frame;
    private JButton importButton;
    private String demoFilesUrl;
    private static int fileNameIncrementer = 1;
    protected JTextField urlField;

    private void displayInFrame(JPanel panel) {
        this.frame = new JFrame();
        this.frame.getContentPane().add(panel);
        this.frame.pack();
        this.frame.setLocation(100, 50);
        this.frame.setVisible(true);
    }

    private boolean downloadUrl(String url) {
        Registry reg = EditorAgent.getRegistry();
        UserNotifier un = reg.getUserNotifier();
        try {
            int lastSlash = url.lastIndexOf("/");
            if (lastSlash < 0) {
                return false;
            }
            String newFileName = url.substring(lastSlash);
            if (new File(newFileName).exists()) {
                String fileExt = ".cpe.xml";
                newFileName = newFileName.contains(fileExt) ? newFileName.replace(fileExt, fileNameIncrementer++ + fileExt) : newFileName + fileNameIncrementer++;
            }
            File downloadedFile = FileDownload.downloadFile(url, newFileName);
            this.model.openLocalFile(downloadedFile);
            this.model.setEdited(true);
            downloadedFile.delete();
            return true;
        }
        catch (MalformedURLException ex) {
            un.notifyInfo("Invalid URL, please try again", "Invalid URL");
            return false;
        }
        catch (IOException ex) {
            un.notifyInfo("Could not open file. \nURL may be incorrect, or internet connection failed.", "Could not open file");
            return false;
        }
        catch (IllegalArgumentException ex) {
            un.notifyInfo("Invalid URL", "Invalid URL, please try again");
            return false;
        }
    }

    public UrlChooser(Editor model) {
        this.model = model;
        this.demoFilesUrl = (String)EditorAgent.getRegistry().lookup("/demo/index");
        this.buildAndDisplayUI();
    }

    public void buildAndDisplayUI() {
        this.setLayout(new BorderLayout());
        int panelWidth = 700;
        String headerMessage = "Choose an example file to open.";
        Icon headerIcon = IconManager.getInstance().getIcon(72);
        TitlePanel titlePanel = new TitlePanel("Import Demo File", headerMessage, headerIcon);
        this.add((Component)((Object)titlePanel), "North");
        JEditorPane webPage = new JEditorPane();
        try {
            webPage.setPage(this.demoFilesUrl);
        }
        catch (IOException e1) {
            Registry registry = EditorAgent.getRegistry();
            registry.getUserNotifier().notifyInfo("Problem accessing online files", "Could not access the online example files. \nPlease check your internet connection.");
            return;
        }
        webPage.setEditable(false);
        webPage.addHyperlinkListener(this);
        Dimension scrollPaneSize = new Dimension(panelWidth, 450);
        JScrollPane scrollPane = new JScrollPane(webPage, 22, 31);
        scrollPane.setPreferredSize(scrollPaneSize);
        scrollPane.setMinimumSize(scrollPaneSize);
        this.add((Component)scrollPane, "Center");
        this.urlField = new JTextField("http://");
        this.importButton = new JButton("Import");
        this.importButton.setEnabled(false);
        this.importButton.addActionListener(this);
        this.importButton.setSelected(true);
        JButton cancelButton = new JButton("Cancel");
        cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                UrlChooser.this.frame.setVisible(false);
            }
        });
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(cancelButton);
        buttonBox.add(this.importButton);
        buttonBox.add(Box.createHorizontalStrut(12));
        JPanel buttonBoxContainer = new JPanel(new BorderLayout());
        buttonBoxContainer.add((Component)buttonBox, "East");
        Box verticalBox = Box.createVerticalBox();
        verticalBox.add(this.urlField);
        verticalBox.add(buttonBoxContainer);
        this.add((Component)verticalBox, "South");
        this.displayInFrame(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (this.downloadUrl(this.urlField.getText())) {
            this.frame.setVisible(false);
        }
    }

    public void hyperlinkUpdate(HyperlinkEvent event) {
        String url;
        if (event.getEventType() == HyperlinkEvent.EventType.ACTIVATED && event != null && (url = event.getURL().toString()) != null) {
            boolean cpeFile = url.endsWith("cpe.xml");
            if (cpeFile) {
                this.urlField.setText(url);
                this.importButton.setEnabled(true);
            } else {
                new BrowserLauncher().openURL(url);
            }
        }
    }
}

