/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.uiComponents;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomLabel;
import org.openmicroscopy.shoola.util.image.geom.Factory;

public class ImagePreview
extends JPanel {
    private String imagePath;

    private void buildUI() {
        this.setLayout(new BorderLayout());
        this.setBackground(null);
        URL imageURL = null;
        String osSensitiveImagePath = this.imagePath;
        osSensitiveImagePath = System.getProperty("os.name").startsWith("Mac OS") ? "file://" + this.imagePath : "file:///" + this.imagePath;
        try {
            imageURL = new URL(osSensitiveImagePath);
        }
        catch (MalformedURLException ex) {
            ex.printStackTrace();
            return;
        }
        ImageIcon imageIcon = new ImageIcon(imageURL);
        try {
            String max = (String)EditorAgent.getRegistry().lookup("/ui/thumbnail");
            BufferedImage image = Factory.createImage(imageIcon.getImage());
            int maxDimension = Math.max(image.getWidth(), image.getHeight());
            Float ratio = Float.valueOf(Float.valueOf(max).floatValue() / (float)maxDimension);
            image = Factory.magnifyImage(ratio.floatValue(), image);
            imageIcon.setImage(image);
        }
        catch (Exception ex) {
            // empty catch block
        }
        CustomLabel imageLabel = new CustomLabel();
        imageLabel.setIcon(imageIcon);
        this.add((Component)imageLabel, "West");
    }

    public ImagePreview(String imagePath) {
        this.imagePath = imagePath;
        this.buildUI();
    }
}

