/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.uiComponents;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.editor.uiComponents.DoubleDigitField;

public class HrsMinsSecsField
extends JPanel
implements PropertyChangeListener {
    protected DoubleDigitField hrsField;
    protected DoubleDigitField minsField;
    protected DoubleDigitField secsField;
    public static final String TIME_IN_SECONDS = "timeInSeconds";
    protected int currentTimeInSecs = 0;

    public HrsMinsSecsField() {
        this.setLayout(new BoxLayout(this, 0));
        this.setBackground(null);
        this.hrsField = new DoubleDigitField(0, 23);
        this.hrsField.addPropertyChangeListener("digitValueProperty", this);
        this.minsField = new DoubleDigitField(0, 59);
        this.minsField.addPropertyChangeListener("digitValueProperty", this);
        this.secsField = new DoubleDigitField(0, 59);
        this.secsField.addPropertyChangeListener("digitValueProperty", this);
        this.add(this.hrsField);
        this.add(new JLabel(":"));
        this.add(this.minsField);
        this.add(new JLabel(":"));
        this.add(this.secsField);
        this.setTimeInSecs(0);
    }

    public void setTimeInSecs(int timeInSecs) {
        int hours = 0;
        int mins = 0;
        int secs = 0;
        hours = timeInSecs / 3600;
        mins = (timeInSecs - hours * 3600) / 60;
        secs = timeInSecs - hours * 3600 - mins * 60;
        this.hrsField.setText(hours + "");
        this.minsField.setText(mins + "");
        this.secsField.setText(secs + "");
        this.currentTimeInSecs = timeInSecs;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("digitValueProperty".equals(evt.getPropertyName())) {
            int newTimeInSecs = this.getTimeInSecs();
            this.firePropertyChange(TIME_IN_SECONDS, this.currentTimeInSecs, newTimeInSecs);
            this.currentTimeInSecs = newTimeInSecs;
        }
    }

    public int getTimeInSecs() {
        int hrs = new Integer(this.hrsField.getText().toString());
        int mins = new Integer(this.minsField.getText().toString());
        int secs = new Integer(this.secsField.getText().toString());
        return hrs * 3600 + mins * 60 + secs;
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.hrsField.setEnabled(enabled);
        this.minsField.setEnabled(enabled);
        this.secsField.setEnabled(enabled);
    }
}

