/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.uiComponents;

import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import org.openmicroscopy.shoola.agents.editor.IconManager;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomButton;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomPopupMenu;

public class DropDownMenu
extends CustomButton
implements PropertyChangeListener {
    private CustomPopupMenu popupMenu;
    private String[] options;
    public static final String SELECTION = "itemSelection";
    private int selectedIndex;

    public DropDownMenu(String[] options) {
        Icon upDownIcon = IconManager.getInstance().getIcon(59);
        this.setIcon(upDownIcon);
        this.setHorizontalTextPosition(2);
        this.setIconTextGap(2);
        this.options = options;
        this.addMouseListener(new PopupListener());
        this.popupMenu = new CustomPopupMenu(options);
        this.popupMenu.addPropertyChangeListener(this);
    }

    public void setSelectedItem(String item) {
        if (item == null) {
            return;
        }
        for (int i = 0; i < this.options.length; ++i) {
            if (!item.equals(this.options[i])) continue;
            this.setText(item);
            this.selectedIndex = i;
            return;
        }
    }

    public void setSelectedIndex(int i) {
        if (i >= 0 && i < this.options.length) {
            this.setText(this.options[i]);
            this.selectedIndex = i;
        }
    }

    public int getSelectedIndex() {
        return this.selectedIndex;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("itemName".equals(evt.getPropertyName())) {
            String oldValue = this.getText();
            String newValue = evt.getNewValue().toString();
            this.setSelectedItem(newValue);
            this.firePropertyChange(SELECTION, oldValue, newValue);
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        public void mouseClicked(MouseEvent e) {
            DropDownMenu.this.popupMenu.show(e.getComponent(), 0, 0);
        }
    }
}

