/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.preview;

import java.io.File;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.editor.browser.MetadataPanelsComponent;
import org.openmicroscopy.shoola.agents.editor.preview.AnnotationHandler;
import org.openmicroscopy.shoola.agents.editor.preview.EditorPreviewModel;
import org.openmicroscopy.shoola.agents.editor.preview.EditorPreviewUI;
import org.openmicroscopy.shoola.agents.util.editorpreview.PreviewPanel;
import pojos.FileAnnotationData;

public class EditorPreview
implements AnnotationHandler {
    private BrowserControl controller;
    private long fileID;
    private FileAnnotationData fileAnnotation;
    private String filePath;
    private EditorPreviewUI view;
    private String annotationDesc;
    private PreviewPanel previewPanel;
    private MetadataPanelsComponent mdc;
    private EditorPreviewModel model;

    private void initialise(JPanel preview, String title) {
        this.view = new EditorPreviewUI(this, preview);
        this.view.setTitle(title);
    }

    public EditorPreview(String filePath, BrowserControl controller) {
        File f;
        this.filePath = filePath;
        this.controller = controller;
        String title = "File not found";
        if (filePath != null && (f = new File(filePath)).exists()) {
            title = f.getName();
        }
        this.mdc = new MetadataPanelsComponent(null);
        this.initialise(this.mdc, title);
    }

    public EditorPreview(long fileID, BrowserControl controller) {
        this.fileID = fileID;
        this.controller = controller;
        this.previewPanel = new PreviewPanel();
        this.initialise(this.previewPanel, "File ID: " + fileID);
    }

    void loadPreviewData() {
        File editorFile;
        if (this.fileID != 0L) {
            if (!EditorAgent.isServerAvailable()) {
                this.annotationDesc = "<protocol><n>File ID: " + this.fileID + " on server</n>" + "<d>Can't show the preview of this file because " + "OMERO.editor is not connected to the server.</d>" + "</protocol>";
            } else if (this.annotationDesc == null) {
                this.controller.getFileAnnotation(this.fileID, this);
            }
        } else if (this.filePath != null && this.model == null && (editorFile = new File(this.filePath)).exists()) {
            this.model = new EditorPreviewModel();
            this.model.setFileToEdit(editorFile);
            this.mdc.setTreeModel(this.model.getModel());
            this.view.setTitle(this.mdc.getProtocolTitle());
        }
    }

    public JComponent getUI() {
        return this.view;
    }

    public void handleAnnotation(FileAnnotationData fileAnnotation) {
        this.annotationDesc = fileAnnotation.getDescription();
        this.previewPanel.setDescriptionXml(this.annotationDesc);
        this.view.setTitle(this.previewPanel.getTitle());
    }
}

