/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.undoableEdits;

import java.util.ArrayList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.editor.model.TreeModelMethods;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.UndoableTreeEdit;

public class DeleteFieldsEdit
extends UndoableTreeEdit {
    private ArrayList<MutableTreeNode> deletedFields = new ArrayList();
    private int indexOfFirstHighlightedField;
    private DefaultMutableTreeNode parentNode;

    public DeleteFieldsEdit(JTree tree) {
        super(tree);
    }

    public static boolean canDo(TreePath[] paths) {
        if (paths == null) {
            return false;
        }
        if (paths.length == 0) {
            return false;
        }
        TreePath p = paths[0];
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)p.getLastPathComponent();
        return !selectedNode.isRoot();
    }

    public void doEdit() {
        if (this.tree == null) {
            return;
        }
        TreePath[] selectedPaths = this.tree.getSelectionPaths();
        if (!DeleteFieldsEdit.canDo(selectedPaths)) {
            return;
        }
        if (selectedPaths.length > 0) {
            DefaultMutableTreeNode firstField = (DefaultMutableTreeNode)selectedPaths[0].getLastPathComponent();
            this.indexOfFirstHighlightedField = firstField.getParent().getIndex(firstField);
            this.parentNode = (DefaultMutableTreeNode)firstField.getParent();
            for (int i = 0; i < selectedPaths.length; ++i) {
                DefaultMutableTreeNode currentNode = (DefaultMutableTreeNode)selectedPaths[i].getLastPathComponent();
                MutableTreeNode parent = (MutableTreeNode)currentNode.getParent();
                if (parent != null) {
                    this.treeModel.removeNodeFromParent(currentNode);
                }
                this.deletedFields.add(currentNode);
            }
        }
    }

    public void undo() {
        TreeModelMethods.insertNodesInto(this.treeModel, this.deletedFields, this.parentNode, this.indexOfFirstHighlightedField);
        TreeModelMethods.selectNodes(this.deletedFields, this.tree);
    }

    public void redo() {
        TreeModelMethods.removeNodesFromParent(this.treeModel, this.deletedFields);
        this.tree.clearSelection();
    }

    public String getPresentationName() {
        return "Delete Fields";
    }

    public boolean canUndo() {
        return true;
    }

    public boolean canRedo() {
        return true;
    }
}

