/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.undoableEdits;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.IFieldContent;
import org.openmicroscopy.shoola.agents.editor.model.TreeIterator;
import org.openmicroscopy.shoola.agents.editor.model.params.IParam;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.TreeEdit;

public class ClearValuesEdit
extends AbstractUndoableEdit
implements TreeEdit {
    private DefaultMutableTreeNode root;
    DefaultTreeModel treeModel;
    private HashMap<IParam, List<Object>> clearedParams;
    private HashMap<IParam, DefaultMutableTreeNode> paramNodes;

    private void getClearedParams() {
        this.clearedParams = new HashMap();
        this.paramNodes = new HashMap();
        TreeIterator iterator = new TreeIterator(this.root);
        while (iterator.hasNext()) {
            IField f;
            int paramCount;
            DefaultMutableTreeNode node;
            Object userOb;
            TreeNode tn = (TreeNode)iterator.next();
            if (!(tn instanceof DefaultMutableTreeNode) || !((userOb = (node = (DefaultMutableTreeNode)tn).getUserObject()) instanceof IField) || (paramCount = (f = (IField)userOb).getContentCount()) == 0) continue;
            for (int i = 0; i < paramCount; ++i) {
                IParam param;
                int valueCount;
                IFieldContent content = f.getContentAt(i);
                if (!(content instanceof IParam) || (valueCount = (param = (IParam)content).getValueCount()) == 0) continue;
                ArrayList<Object> values = new ArrayList<Object>();
                for (int v = 0; v < valueCount; ++v) {
                    values.add(param.getValueAt(v));
                }
                this.clearedParams.put(param, values);
                this.paramNodes.put(param, node);
            }
        }
    }

    public ClearValuesEdit(JTree tree) {
        this.setTree(tree);
        this.doEdit();
    }

    private void doEdit() {
        if (this.treeModel == null) {
            return;
        }
        this.root = (DefaultMutableTreeNode)this.treeModel.getRoot();
        this.getClearedParams();
        this.redo();
    }

    public void undo() {
        for (IParam p : this.clearedParams.keySet()) {
            List<Object> values = this.clearedParams.get(p);
            for (int v = 0; v < values.size(); ++v) {
                p.setValueAt(v, values.get(v));
            }
            TreeNode n = this.paramNodes.get(p);
            this.notifyNodeChanged(n);
        }
    }

    public void redo() {
        for (IParam p : this.clearedParams.keySet()) {
            List<Object> values = this.clearedParams.get(p);
            for (int v = 0; v < values.size(); ++v) {
                p.removeValueAt(0);
            }
            TreeNode n = this.paramNodes.get(p);
            this.notifyNodeChanged(n);
        }
    }

    public boolean canUndo() {
        return true;
    }

    public boolean canRedo() {
        return true;
    }

    public String getPresentationName() {
        return "Delete Experiment Info";
    }

    private void notifyNodeChanged(TreeNode node) {
        if (this.treeModel != null) {
            this.treeModel.nodeChanged(node);
        }
    }

    public void setTree(JTree tree) {
        if (tree != null) {
            this.treeModel = (DefaultTreeModel)tree.getModel();
        }
    }
}

