/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.undoableEdits;

import javax.swing.JTree;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.TreeModelMethods;
import org.openmicroscopy.shoola.agents.editor.model.tables.TableModelFactory;

public class AddFieldTableEdit
extends AbstractUndoableEdit {
    private IField field;
    private JTree tree;
    private TreeNode node;
    private TableModel newTableAdaptor;
    private TableModel oldTableAdaptor;
    private TableModel newTableData;
    private TableModel oldTableData;

    private void initialise(IField field, JTree tree, TreeNode node, TableModel tableAdaptor) {
        this.field = field;
        this.tree = tree;
        this.node = node;
        this.newTableAdaptor = tableAdaptor;
        if (tableAdaptor == null) {
            // empty if block
        }
        this.oldTableAdaptor = field.getTableData();
        this.redo();
    }

    public AddFieldTableEdit(IField field, JTree tree, TreeNode node) {
        TableModel tm = TableModelFactory.getFieldTable(field);
        this.initialise(field, tree, node, tm);
    }

    public AddFieldTableEdit(IField field, JTree tree, TreeNode node, TableModel tableModel) {
        this.initialise(field, tree, node, tableModel);
    }

    public static boolean canDo(IField newField) {
        return newField.getAtomicParams().size() != 0;
    }

    public void undo() {
        Object cellValue;
        int c;
        int r;
        int cols;
        int rows;
        this.newTableAdaptor = this.field.getTableData();
        if (this.newTableAdaptor != null) {
            rows = this.newTableAdaptor.getRowCount();
            cols = this.newTableAdaptor.getColumnCount();
            this.newTableData = new DefaultTableModel(rows, cols);
            for (r = 0; r < rows; ++r) {
                for (c = 0; c < cols; ++c) {
                    cellValue = this.newTableAdaptor.getValueAt(r, c);
                    this.newTableData.setValueAt(cellValue, r, c);
                    if (r <= 0) continue;
                    this.newTableAdaptor.setValueAt(null, r, c);
                }
            }
        }
        this.field.setTableData(this.oldTableAdaptor);
        if (this.oldTableData != null) {
            rows = this.oldTableData.getRowCount();
            cols = this.oldTableData.getColumnCount();
            for (r = 0; r < rows; ++r) {
                for (c = 0; c < cols; ++c) {
                    cellValue = this.oldTableData.getValueAt(r, c);
                    this.oldTableAdaptor.setValueAt(cellValue, r, c);
                    this.oldTableData.setValueAt(null, r, c);
                }
            }
        }
        this.notifySelectStartEdit();
    }

    public void redo() {
        Object cellValue;
        int c;
        int r;
        int cols;
        int rows;
        this.oldTableAdaptor = this.field.getTableData();
        if (this.oldTableAdaptor != null) {
            rows = this.oldTableAdaptor.getRowCount();
            cols = this.oldTableAdaptor.getColumnCount();
            this.oldTableData = new DefaultTableModel(rows, cols);
            for (r = 0; r < rows; ++r) {
                for (c = 0; c < cols; ++c) {
                    cellValue = this.oldTableAdaptor.getValueAt(r, c);
                    this.oldTableData.setValueAt(cellValue, r, c);
                    if (r <= 0) continue;
                    this.oldTableAdaptor.setValueAt(null, r, c);
                }
            }
        }
        this.field.setTableData(this.newTableAdaptor);
        if (this.newTableData != null) {
            rows = this.newTableData.getRowCount();
            cols = this.newTableData.getColumnCount();
            for (r = 0; r < rows; ++r) {
                for (c = 0; c < cols; ++c) {
                    cellValue = this.newTableData.getValueAt(r, c);
                    this.newTableAdaptor.setValueAt(cellValue, r, c);
                    this.newTableData.setValueAt(null, r, c);
                }
            }
        }
        this.notifySelectStartEdit();
    }

    public boolean canUndo() {
        return true;
    }

    public boolean canRedo() {
        return true;
    }

    private void notifySelectStartEdit() {
        this.notifyNodeChanged();
        TreeModelMethods.selectNode(this.node, this.tree);
        DefaultMutableTreeNode dmtNode = (DefaultMutableTreeNode)this.node;
        TreePath path = new TreePath(dmtNode.getPath());
        if (this.tree != null) {
            this.tree.startEditingAtPath(path);
        }
    }

    private void notifyNodeChanged() {
        if (this.tree != null && this.node != null) {
            DefaultMutableTreeNode dmtNode = (DefaultMutableTreeNode)this.node;
            DefaultTreeModel treeModel = (DefaultTreeModel)this.tree.getModel();
            treeModel.nodeChanged(this.node);
        }
    }
}

