/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model.params;

import java.util.HashMap;
import org.openmicroscopy.shoola.agents.editor.model.params.AbstractParam;
import org.openmicroscopy.shoola.agents.editor.model.params.BooleanParam;
import org.openmicroscopy.shoola.agents.editor.model.params.DateTimeParam;
import org.openmicroscopy.shoola.agents.editor.model.params.EditorLinkParam;
import org.openmicroscopy.shoola.agents.editor.model.params.EnumParam;
import org.openmicroscopy.shoola.agents.editor.model.params.IParam;
import org.openmicroscopy.shoola.agents.editor.model.params.NumberParam;
import org.openmicroscopy.shoola.agents.editor.model.params.OntologyTermParam;
import org.openmicroscopy.shoola.agents.editor.model.params.TextBoxParam;
import org.openmicroscopy.shoola.agents.editor.model.params.TextParam;

public class FieldParamsFactory {
    public static final String NO_PARAMS = "noParams";
    private static final String[] PARAM_TYPES = new String[]{"TEXT", "NUMERIC", "BOOLEAN", "ENUMERATION", "DATE_TIME", "editorLinkParam", "ONTOLOGYTERM"};
    private static final String[] UI_INPUT_TYPES = new String[]{"Text", "Number", "Check-Box", "Drop-down Menu", "Date & Time", "Editor File Link", "Ontology Term"};

    public static String[] getParamTypes() {
        return PARAM_TYPES;
    }

    public static String[] getUiParamTypes() {
        return UI_INPUT_TYPES;
    }

    public static String getTypeForDisplay(String paramType) {
        if (paramType == null) {
            return null;
        }
        int paramTypesLength = PARAM_TYPES.length;
        for (int i = 0; i < paramTypesLength; ++i) {
            if (!PARAM_TYPES[i].equals(paramType)) continue;
            return UI_INPUT_TYPES[i];
        }
        return paramType;
    }

    public static IParam getFieldParam(String paramType) {
        AbstractParam fieldValue = null;
        if (paramType.equals("TEXT")) {
            fieldValue = new TextParam("TEXT");
        } else if (paramType.equals("TEXTBOX")) {
            fieldValue = new TextBoxParam("TEXTBOX");
        } else if (paramType.equals("NUMERIC")) {
            fieldValue = new NumberParam();
        } else if (paramType.equals("ENUMERATION")) {
            fieldValue = new EnumParam();
        } else if (paramType.equals("BOOLEAN")) {
            fieldValue = new BooleanParam();
        } else if (paramType.equals("DATE_TIME")) {
            fieldValue = new DateTimeParam();
        } else if (paramType.equals("editorLinkParam")) {
            fieldValue = new EditorLinkParam();
        } else if (paramType.equals("ONTOLOGYTERM")) {
            fieldValue = new OntologyTermParam();
        } else {
            System.err.println("FieldParamsFactory: PARAM_TYPE " + paramType + " " + "NOT RECOGNIZED. Return NULL IParam");
        }
        return fieldValue;
    }

    public static IParam cloneParam(IParam cloneThis) {
        String paramType = cloneThis.getAttribute("paramType");
        AbstractParam newParam = (AbstractParam)FieldParamsFactory.getFieldParam(paramType);
        HashMap<String, String> attr = new HashMap<String, String>(((AbstractParam)cloneThis).getAllAttributes());
        if (newParam != null) {
            newParam.setAllAttributes(attr);
        }
        return newParam;
    }
}

