/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;
import org.openmicroscopy.shoola.agents.editor.model.DataReference;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.IFieldContent;
import org.openmicroscopy.shoola.agents.editor.model.Note;
import org.openmicroscopy.shoola.agents.editor.model.TextContent;
import org.openmicroscopy.shoola.agents.editor.model.params.BooleanParam;
import org.openmicroscopy.shoola.agents.editor.model.params.EditorLinkParam;
import org.openmicroscopy.shoola.agents.editor.model.params.EnumParam;
import org.openmicroscopy.shoola.agents.editor.model.params.IParam;
import org.openmicroscopy.shoola.agents.editor.model.params.NumberParam;
import org.openmicroscopy.shoola.agents.editor.model.params.TextParam;
import org.openmicroscopy.shoola.agents.editor.model.tables.TableModelFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field
implements IField,
Cloneable {
    public static final String FIELD_NAME = "fieldName";
    public static final String BACKGROUND_COLOUR = "backgroundColour";
    public static final String STEP_TYPE = "step-type";
    public static final String TOOL_TIP_TEXT = "toolTipText";
    private List<IFieldContent> fieldParams;
    private HashMap<String, String> templateAttributesMap = new HashMap();
    private TableModel tableData;
    private List<Note> stepNotes;
    private List<DataReference> dataRefs;

    public Field() {
        this.fieldParams = new ArrayList<IFieldContent>();
        this.stepNotes = new ArrayList<Note>();
        this.dataRefs = new ArrayList<DataReference>();
    }

    public IField clone() {
        Field newField = new Field();
        HashMap<String, String> newAtt = new HashMap<String, String>(this.getAllAttributes());
        newField.setAllAttributes(newAtt);
        for (int i = 0; i < this.getContentCount(); ++i) {
            IFieldContent newContent;
            IFieldContent content = this.getContentAt(i);
            if (content instanceof IParam) {
                IParam param = (IParam)content;
                newContent = param.cloneParam();
                newField.addContent(newContent);
                continue;
            }
            if (!(content instanceof TextContent)) continue;
            TextContent text = (TextContent)content;
            newContent = new TextContent(text);
            newField.addContent(newContent);
        }
        if (this.getTableData() != null) {
            TableModel tm = TableModelFactory.getFieldTable(newField);
            newField.setTableData(tm);
        }
        return newField;
    }

    public Field(String name) {
        this();
        this.setAttribute(FIELD_NAME, name);
    }

    @Override
    public String getAttribute(String name) {
        return this.templateAttributesMap.get(name);
    }

    public Map getAllAttributes() {
        return this.templateAttributesMap;
    }

    public void setAllAttributes(HashMap<String, String> newAtt) {
        this.templateAttributesMap = newAtt;
    }

    @Override
    public void setAttribute(String name, String value) {
        this.templateAttributesMap.put(name, value);
    }

    public String toString() {
        String name = this.getAttribute(FIELD_NAME);
        return name == null ? "Step Name" : name;
    }

    @Override
    public boolean isAttributeTrue(String attributeName) {
        String value = this.getAttribute(attributeName);
        return "true".equals(value);
    }

    @Override
    public int getUnfilledCount() {
        return this.getUnfilledCount(false);
    }

    @Override
    public int getUnfilledCount(boolean requiredOnly) {
        int unfilledCount = 0;
        for (IFieldContent content : this.fieldParams) {
            if (!(content instanceof IParam)) continue;
            IParam param = (IParam)content;
            if (requiredOnly && !param.isAttributeTrue("paramRequired") || param.isParamFilled()) continue;
            ++unfilledCount;
        }
        return unfilledCount;
    }

    @Override
    public int getContentCount() {
        return this.fieldParams.size();
    }

    @Override
    public IFieldContent getContentAt(int index) {
        return this.fieldParams.get(index);
    }

    @Override
    public void addContent(IFieldContent param) {
        if (param != null) {
            this.fieldParams.add(param);
        }
    }

    @Override
    public void addContent(int index, IFieldContent param) {
        if (param != null) {
            this.fieldParams.add(index, param);
        }
    }

    @Override
    public int removeContent(IFieldContent param) {
        int index = this.fieldParams.indexOf(param);
        this.fieldParams.remove(param);
        return index;
    }

    @Override
    public void removeContent(int index) {
        this.fieldParams.remove(index);
    }

    @Override
    public List<IParam> getAtomicParams() {
        ArrayList<IParam> params = new ArrayList<IParam>();
        for (IFieldContent content : this.fieldParams) {
            if (!(content instanceof BooleanParam) && !(content instanceof EnumParam) && !(content instanceof TextParam) && !(content instanceof EditorLinkParam) && !(content instanceof NumberParam)) continue;
            params.add((IParam)content);
        }
        return params;
    }

    @Override
    public void addNote(Note note) {
        this.stepNotes.add(note);
    }

    @Override
    public void addNote(Note note, int index) {
        this.stepNotes.add(index, note);
    }

    @Override
    public int removeNote(Note note) {
        int index = this.stepNotes.indexOf(note);
        this.stepNotes.remove(note);
        return index;
    }

    @Override
    public int getNoteCount() {
        return this.stepNotes.size();
    }

    @Override
    public Note getNoteAt(int index) {
        return this.stepNotes.get(index);
    }

    @Override
    public String getToolTipText() {
        String toolTipText = "";
        List<IParam> params = this.getAtomicParams();
        for (IParam param : params) {
            String paramText = param.toString();
            if (toolTipText.length() > 0) {
                toolTipText = toolTipText + ", ";
            }
            toolTipText = toolTipText + paramText;
        }
        return toolTipText;
    }

    @Override
    public void setTableData(TableModel tableModel) {
        this.tableData = tableModel;
    }

    @Override
    public TableModel getTableData() {
        return this.tableData;
    }

    @Override
    public void addDataRef(DataReference ref) {
        this.dataRefs.add(ref);
    }

    @Override
    public DataReference getDataRefAt(int index) {
        return this.dataRefs.get(index);
    }

    @Override
    public int getDataRefCount() {
        return this.dataRefs.size();
    }

    @Override
    public void addDataRef(int index, DataReference ref) {
        this.dataRefs.add(index, ref);
    }

    @Override
    public int removeDataRef(DataReference ref) {
        int index = this.dataRefs.indexOf(ref);
        this.dataRefs.remove(ref);
        return index;
    }
}

