/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLWriter;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.model.CPEexport;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.IFieldContent;
import org.openmicroscopy.shoola.agents.editor.model.TreeModelMethods;
import org.openmicroscopy.shoola.agents.editor.model.params.DateTimeParam;
import org.openmicroscopy.shoola.agents.editor.model.params.EnumParam;
import org.openmicroscopy.shoola.agents.editor.model.params.IParam;
import org.openmicroscopy.shoola.agents.editor.model.params.NumberParam;
import org.openmicroscopy.shoola.env.config.Registry;

public class CPEsummaryExport {
    private static final int MAX_LINES = 15;
    public static final int MAX_DESC = 500;
    private static int lines;

    private static void buildSteps(TreeNode node, IXMLElement stepList, int level) {
        if (lines > 15) {
            return;
        }
        IField field = CPEexport.getFieldFromTreeNode(node);
        XMLElement step = new XMLElement("s");
        step.setAttribute("l", level + "");
        String name = field.getAttribute("fieldName");
        if (name == null) {
            name = TreeModelMethods.getNodeName((DefaultMutableTreeNode)node);
        }
        step.setAttribute("n", name);
        int contentCount = field.getContentCount();
        int paramCount = 0;
        for (int i = 0; i < contentCount; ++i) {
            IFieldContent content = field.getContentAt(i);
            if (!(content instanceof IParam)) continue;
            ++paramCount;
            IXMLElement parameter = CPEsummaryExport.createParamElement((IParam)content);
            if (lines >= 15) continue;
            step.addChild(parameter);
            ++lines;
        }
        if (paramCount > 0 && lines < 15) {
            stepList.addChild((IXMLElement)step);
            ++lines;
        }
        int childLevel = level + 1;
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode childNode = node.getChildAt(i);
            CPEsummaryExport.buildSteps(childNode, stepList, childLevel);
        }
    }

    private static IXMLElement createParamElement(IParam param) {
        String units;
        XMLElement parameter = new XMLElement("p");
        String name = param.getAttribute("paramName");
        if (name == null) {
            name = "param";
        }
        if ((param instanceof NumberParam || param instanceof EnumParam) && (units = param.getAttribute("paramUnits")) != null) {
            name = name + " (" + units + ")";
        }
        CPEexport.addChildContent((IXMLElement)parameter, "n", name);
        String value = "";
        int valueCount = param.getValueCount();
        for (int i = 0; i < valueCount; ++i) {
            Object o;
            if (i > 0) {
                value = value + ", ";
            }
            if ((o = param.getValueAt(i)) == null) continue;
            String v = o.toString();
            if (param instanceof DateTimeParam) {
                v = DateTimeParam.formatDate(v);
            }
            value = value + v;
        }
        CPEexport.addChildContent((IXMLElement)parameter, "v", value);
        return parameter;
    }

    public static String export(TreeModel treeModel) {
        StringWriter output;
        XMLElement protocol = new XMLElement("protocol");
        TreeNode root = (TreeNode)treeModel.getRoot();
        IField protocolRoot = CPEexport.getFieldFromTreeNode(root);
        String protName = protocolRoot.getAttribute("fieldName");
        if (protName == null) {
            protName = TreeModelMethods.getNodeName((DefaultMutableTreeNode)root);
        }
        CPEexport.addChildContent((IXMLElement)protocol, "n", protName);
        if (protocolRoot.getContentCount() > 0) {
            String desc = ((Object)protocolRoot.getContentAt(0)).toString();
            if (desc != null && desc.length() > 500) {
                desc = desc.substring(0, 499) + "...";
            }
            CPEexport.addChildContent((IXMLElement)protocol, "d", desc);
        }
        XMLElement steps = new XMLElement("ss");
        protocol.addChild((IXMLElement)steps);
        lines = 0;
        for (int i = 0; i < root.getChildCount(); ++i) {
            TreeNode childNode = root.getChildAt(i);
            CPEsummaryExport.buildSteps(childNode, (IXMLElement)steps, 0);
        }
        try {
            output = new StringWriter();
            XMLWriter xmlwriter = new XMLWriter((Writer)output);
            xmlwriter.write((IXMLElement)protocol, true);
        }
        catch (IOException e) {
            Registry reg = EditorAgent.getRegistry();
            reg.getLogger().error((Object)new CPEsummaryExport(), e.toString());
            return null;
        }
        if (output != null) {
            String s = ((Object)output).toString();
            return s;
        }
        return null;
    }
}

