/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import net.n3.nanoxml.IXMLElement;
import org.openmicroscopy.shoola.agents.editor.model.DataReference;
import org.openmicroscopy.shoola.agents.editor.model.ExperimentInfo;
import org.openmicroscopy.shoola.agents.editor.model.Field;
import org.openmicroscopy.shoola.agents.editor.model.FieldNode;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.Note;
import org.openmicroscopy.shoola.agents.editor.model.ProtocolRootField;
import org.openmicroscopy.shoola.agents.editor.model.TextBoxStep;
import org.openmicroscopy.shoola.agents.editor.model.TextContent;
import org.openmicroscopy.shoola.agents.editor.model.params.FieldParamsFactory;
import org.openmicroscopy.shoola.agents.editor.model.params.IParam;
import org.openmicroscopy.shoola.agents.editor.model.params.OntologyTermParam;
import org.openmicroscopy.shoola.agents.editor.model.params.TextBoxParam;
import org.openmicroscopy.shoola.agents.editor.model.tables.TableModelFactory;
import org.openmicroscopy.shoola.util.ui.omeeditpane.Position;
import org.openmicroscopy.shoola.util.ui.omeeditpane.WikiView;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CPEimport {
    public static final String PROTOCOL = "protocol";
    public static final String PROTOCOL_INFO = "protocol-information";
    public static final String ARCHIVE_INFO = "archive-info";
    public static final String ARCHIVE_DATE = "archive-date";
    public static final String REVISION = "revision";
    public static final String EXP_INFO = "experiment-information";
    public static final String STEPS = "steps";
    public static final String STEP_CHILDREN = "step-children";
    public static final String STEP = "step";
    public static final String STEP_TYPE = "step-type";
    public static final String SINGLE_STEP = "SINGLE_STEP";
    public static final String STEP_GROUP = "STEP_GROUP";
    public static final String SPLIT_STEP = "SPLIT_STEP";
    public static final String NAME = "name";
    public static final String DESCRIPTION = "description";
    public static final String DATA = "data";
    public static final String VALUE = "value";
    public static final String DEFAULT = "default-value";
    public static final String PARAM_TYPE = "param-type";
    public static final String ID_START = "[[";
    public static final String ID_END = "]]";
    public static final String ID = "id";
    public static final String PARAM_LIST = "parameter-list";
    public static final String PARAM_TABLE = "parameter-table";
    public static final String PARAMETER = "parameter";
    public static final String ENUM_LIST = "enum-list";
    public static final String ENUM = "enum";
    public static final String UNITS = "units";
    public static final String NECESSITY = "necessity";
    public static final String OPTIONAL = "OPTIONAL";
    public static final String REQUIRED = "REQUIRED";
    public static final String NOTES = "notes";
    public static final String NOTE = "note";
    public static final String CONTENT = "content";
    public static final String DATA_REFS = "data-references";
    public static final String DATA_REF = "data-reference";
    public static final String TEXT_BOX_FLAG = "Text Box: ";
    public static final String ONTOLOGY_FLAG = "Ontology Term: ";
    public static final String PROTOCOL_LINK_FLAG = "Protocol Link: ";

    private static String getChildContent(IXMLElement parent, String childName) {
        if (parent == null) {
            return null;
        }
        IXMLElement child = parent.getFirstChildNamed(childName);
        if (child == null) {
            return null;
        }
        return child.getContent();
    }

    private static void setNameValueDefault(IXMLElement cpeParam, IParam param) {
        CPEimport.setName(cpeParam, param);
        IXMLElement data = cpeParam.getFirstChildNamed(DATA);
        if (data != null) {
            ArrayList values = data.getChildrenNamed(VALUE);
            int v = 0;
            for (IXMLElement element : values) {
                String value = element.getContent();
                param.setValueAt(v++, value);
            }
        }
        String attributeValue = CPEimport.getChildContent(cpeParam, DEFAULT);
        param.setAttribute(DEFAULT, attributeValue);
        attributeValue = CPEimport.getChildContent(cpeParam, NECESSITY);
        if (REQUIRED.equals(attributeValue)) {
            param.setAttribute("paramRequired", "true");
        }
    }

    private static void setName(IXMLElement cpeParam, IAttributes param) {
        String attributeValue = CPEimport.getChildContent(cpeParam, NAME);
        param.setAttribute("paramName", attributeValue);
    }

    private static IParam getParameter(IXMLElement cpeParam) {
        IXMLElement data;
        IParam param;
        String paramType = CPEimport.getChildContent(cpeParam, PARAM_TYPE);
        if (paramType == null) {
            return null;
        }
        String desc = CPEimport.getChildContent(cpeParam, DESCRIPTION);
        if ("ENUMERATION".equals(paramType)) {
            IXMLElement enumList = cpeParam.getFirstChildNamed(ENUM_LIST);
            ArrayList enums = enumList.getChildrenNamed(ENUM);
            if (CPEimport.enumsAreBoolean(enums)) {
                param = FieldParamsFactory.getFieldParam("BOOLEAN");
                CPEimport.setNameValueDefault(cpeParam, param);
            } else {
                param = FieldParamsFactory.getFieldParam("ENUMERATION");
                CPEimport.setNameValueDefault(cpeParam, param);
                String enumOptions = "";
                for (IXMLElement e : enums) {
                    if (enumOptions.length() > 0) {
                        enumOptions = enumOptions + ", ";
                    }
                    enumOptions = enumOptions + e.getContent();
                }
                if (enums.size() > 0) {
                    param.setAttribute("enumOptions", enumOptions);
                }
                String units = CPEimport.getChildContent(cpeParam, UNITS);
                param.setAttribute("paramUnits", units);
            }
        } else if ("NUMERIC".equals(paramType)) {
            param = FieldParamsFactory.getFieldParam("NUMERIC");
            CPEimport.setNameValueDefault(cpeParam, param);
            String units = CPEimport.getChildContent(cpeParam, UNITS);
            param.setAttribute("paramUnits", units);
        } else if ("TEXT".equals(paramType)) {
            paramType = "TEXT";
            if (desc != null) {
                if (desc.startsWith(TEXT_BOX_FLAG)) {
                    paramType = "TEXTBOX";
                    if ((desc = desc.substring(TEXT_BOX_FLAG.length())).length() == 0) {
                        desc = null;
                    }
                } else if (desc.startsWith(ONTOLOGY_FLAG)) {
                    paramType = "ONTOLOGYTERM";
                    if ((desc = desc.substring(ONTOLOGY_FLAG.length())).length() == 0) {
                        desc = null;
                    }
                } else if (desc.startsWith(PROTOCOL_LINK_FLAG)) {
                    paramType = "editorLinkParam";
                    if ((desc = desc.substring(PROTOCOL_LINK_FLAG.length())).length() == 0) {
                        desc = null;
                    }
                }
            }
            if ((param = FieldParamsFactory.getFieldParam(paramType)) instanceof OntologyTermParam) {
                CPEimport.setName(cpeParam, param);
                data = cpeParam.getFirstChildNamed(DATA);
                String ontologyTerm = CPEimport.getChildContent(data, VALUE);
                if (ontologyTerm != null) {
                    ((OntologyTermParam)param).setOntologyTerm(ontologyTerm);
                }
            } else {
                CPEimport.setNameValueDefault(cpeParam, param);
            }
        } else if ("DATE_TIME".equals(paramType)) {
            param = FieldParamsFactory.getFieldParam("DATE_TIME");
            CPEimport.setNameValueDefault(cpeParam, param);
        } else {
            param = FieldParamsFactory.getFieldParam(paramType);
            if (param == null) {
                param = FieldParamsFactory.getFieldParam("TEXT");
                CPEimport.setNameValueDefault(cpeParam, param);
            }
            CPEimport.setName(cpeParam, param);
        }
        data = cpeParam.getFirstChildNamed(DATA);
        if (data != null) {
            int index = 0;
            ArrayList values = data.getChildrenNamed(VALUE);
            for (IXMLElement element : values) {
                param.setValueAt(index++, element.getContent());
            }
        }
        param.setAttribute("paramDescription", desc);
        return param;
    }

    private static boolean enumsAreBoolean(List<IXMLElement> enums) {
        if (enums == null) {
            return false;
        }
        if (enums.size() != 2) {
            return false;
        }
        String option1 = enums.get(0).getContent();
        String option2 = enums.get(1).getContent();
        if ("true".equals(option1) && "false".equals(option2)) {
            return true;
        }
        return "false".equals(option1) && "true".equals(option2);
    }

    private static DefaultMutableTreeNode buildStepTree(IXMLElement cpeStep) {
        IField field = CPEimport.createField(cpeStep);
        FieldNode fieldNode = new FieldNode(field);
        IXMLElement childSteps = cpeStep.getFirstChildNamed(STEP_CHILDREN);
        if (childSteps != null) {
            ArrayList children = childSteps.getChildrenNamed(STEP);
            for (IXMLElement child : children) {
                DefaultMutableTreeNode node = CPEimport.buildStepTree(child);
                fieldNode.add(node);
            }
        }
        return fieldNode;
    }

    private static IField createField(IXMLElement cpeStep) {
        Field field = new Field();
        ArrayList<IXMLElement> allParams = new ArrayList<IXMLElement>();
        IXMLElement params = cpeStep.getFirstChildNamed(PARAM_LIST);
        if (params != null) {
            allParams.addAll(params.getChildrenNamed(PARAMETER));
        }
        if ((params = cpeStep.getFirstChildNamed(PARAM_TABLE)) != null) {
            allParams.addAll(params.getChildrenNamed(PARAMETER));
            field.setTableData(TableModelFactory.getFieldTable(field));
        }
        if (allParams.size() == 1 && CPEimport.getParameter((IXMLElement)allParams.get(0)) instanceof TextBoxParam) {
            field = new TextBoxStep();
        }
        String name = CPEimport.getChildContent(cpeStep, NAME);
        field.setAttribute("fieldName", name);
        String description = CPEimport.getChildContent(cpeStep, DESCRIPTION);
        if (allParams.isEmpty()) {
            if (description != null) {
                field.addContent(new TextContent(description));
            }
        } else if (description != null) {
            IParam parameter;
            String content;
            String regex = "\\[\\[[-a-zA-Z0-9+&@#/%?~_|!:,. ;]*\\]\\]";
            ArrayList<Position> positionList = new ArrayList<Position>();
            WikiView.findExpressions(description, regex, positionList);
            int currentPosition = 0;
            for (Position position : positionList) {
                String paramId;
                IXMLElement param;
                int start = position.getStart();
                int end = position.getEnd();
                if (start > currentPosition) {
                    content = description.substring(currentPosition, start);
                    field.addContent(new TextContent(content));
                }
                if ((param = CPEimport.getElementById(allParams, paramId = description.substring(start + 2, end - 2))) != null) {
                    parameter = CPEimport.getParameter(param);
                    field.addContent(parameter);
                    allParams.remove(param);
                } else {
                    content = description.substring(start, end);
                    field.addContent(new TextContent(content));
                }
                currentPosition = end;
            }
            if (currentPosition < description.length()) {
                content = description.substring(currentPosition, description.length());
                field.addContent(new TextContent(content));
            }
            for (IXMLElement element : allParams) {
                parameter = CPEimport.getParameter(element);
                field.addContent(parameter);
            }
        }
        CPEimport.addStepNotes(field, cpeStep);
        String stepType = CPEimport.getChildContent(cpeStep, STEP_TYPE);
        field.setAttribute(STEP_TYPE, stepType);
        CPEimport.addDataReferences(field, cpeStep);
        return field;
    }

    private static void addDataReferences(IField field, IXMLElement cpeStep) {
        IXMLElement dataRefs = cpeStep.getFirstChildNamed(DATA_REFS);
        if (dataRefs != null) {
            ArrayList dRefs = dataRefs.getChildrenNamed(DATA_REF);
            for (IXMLElement dataRef : dRefs) {
                DataReference dr = new DataReference();
                String value = CPEimport.getChildContent(dataRef, NAME);
                dr.setAttribute(NAME, value);
                value = CPEimport.getChildContent(dataRef, DESCRIPTION);
                dr.setAttribute(DESCRIPTION, value);
                value = CPEimport.getChildContent(dataRef, "reference");
                dr.setAttribute("reference", value);
                value = CPEimport.getChildContent(dataRef, "size");
                dr.setAttribute("size", value);
                value = CPEimport.getChildContent(dataRef, "mime-type");
                dr.setAttribute("mime-type", value);
                value = CPEimport.getChildContent(dataRef, "creation-time");
                dr.setAttribute("creation-time", value);
                value = CPEimport.getChildContent(dataRef, "modification-time");
                dr.setAttribute("modification-time", value);
                field.addDataRef(dr);
            }
        }
    }

    private static void addStepNotes(IField field, IXMLElement stepElement) {
        IXMLElement notes = stepElement.getFirstChildNamed(NOTES);
        if (notes == null) {
            return;
        }
        ArrayList noteList = notes.getChildrenNamed(NOTE);
        for (IXMLElement element : noteList) {
            String name = CPEimport.getChildContent(element, NAME);
            String content = CPEimport.getChildContent(element, CONTENT);
            Note note = new Note(name, content);
            field.addNote(note);
        }
    }

    private static IXMLElement getElementById(List<IXMLElement> elems, String id) {
        if (elems == null) {
            return null;
        }
        for (IXMLElement element : elems) {
            String childId = CPEimport.getChildContent(element, ID);
            if (!id.equals(childId)) continue;
            return element;
        }
        return null;
    }

    static TreeModel createTreeModel(IXMLElement root) {
        IXMLElement protocol = root.getFirstChildNamed(PROTOCOL);
        IXMLElement archiveInfo = root.getFirstChildNamed(ARCHIVE_INFO);
        IXMLElement protocolInfo = protocol.getFirstChildNamed(PROTOCOL_INFO);
        ProtocolRootField rootField = new ProtocolRootField();
        String protName = CPEimport.getChildContent(protocolInfo, NAME);
        rootField.setAttribute("fieldName", protName);
        protName = CPEimport.getChildContent(protocolInfo, DESCRIPTION);
        if (protName != null) {
            rootField.addContent(new TextContent(protName));
        }
        protName = CPEimport.getChildContent(archiveInfo, ARCHIVE_DATE);
        rootField.setAttribute(ARCHIVE_DATE, protName);
        protName = CPEimport.getChildContent(protocolInfo, REVISION);
        rootField.setAttribute(REVISION, protName);
        IXMLElement expInfo = protocolInfo.getFirstChildNamed(EXP_INFO);
        if (expInfo != null) {
            ExperimentInfo experimentInfo = new ExperimentInfo();
            protName = CPEimport.getChildContent(expInfo, "experiment-date");
            experimentInfo.setAttribute("experiment-date", protName);
            protName = CPEimport.getChildContent(expInfo, "investigator-name");
            experimentInfo.setAttribute("investigator-name", protName);
            rootField.setExpInfo(experimentInfo);
        }
        FieldNode rootNode = new FieldNode(rootField);
        IXMLElement steps = protocol.getFirstChildNamed(STEPS);
        ArrayList stepList = steps.getChildren();
        for (IXMLElement step : stepList) {
            DefaultMutableTreeNode treeNode = CPEimport.buildStepTree(step);
            rootNode.add(treeNode);
        }
        return new DefaultTreeModel(rootNode);
    }
}

