/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.model;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.Date;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import net.n3.nanoxml.IXMLElement;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLWriter;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.model.DataReference;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.IFieldContent;
import org.openmicroscopy.shoola.agents.editor.model.Note;
import org.openmicroscopy.shoola.agents.editor.model.ProtocolRootField;
import org.openmicroscopy.shoola.agents.editor.model.params.BooleanParam;
import org.openmicroscopy.shoola.agents.editor.model.params.DateTimeParam;
import org.openmicroscopy.shoola.agents.editor.model.params.EditorLinkParam;
import org.openmicroscopy.shoola.agents.editor.model.params.EnumParam;
import org.openmicroscopy.shoola.agents.editor.model.params.IParam;
import org.openmicroscopy.shoola.agents.editor.model.params.NumberParam;
import org.openmicroscopy.shoola.agents.editor.model.params.OntologyTermParam;
import org.openmicroscopy.shoola.agents.editor.model.params.TextBoxParam;
import org.openmicroscopy.shoola.agents.editor.model.params.TextParam;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.ui.UserNotifier;

public class CPEexport {
    public static final String XML_HEADER = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    private String cpeDtd;
    private String cpeStyles;
    private int paramID = 0;

    public CPEexport() {
        String dtd = (String)EditorAgent.getRegistry().lookup("/xml/cpe.dtd");
        String xsl = (String)EditorAgent.getRegistry().lookup("/xml/editor.xsl");
        this.cpeDtd = "<!DOCTYPE protocol-archive PUBLIC \"-//Common Protocol Exchange Format//DTD upe 1.0//EN\" \"" + dtd + "\">";
        if (xsl != null && xsl.length() > 0) {
            this.cpeStyles = "<?xml-stylesheet href=\"" + xsl + "\"" + " type=\"text/xsl\"?>";
        }
    }

    private IXMLElement buildSteps(TreeNode node) {
        IField field = CPEexport.getFieldFromTreeNode(node);
        IXMLElement rootStep = this.createStepElement(field);
        XMLElement childSteps = new XMLElement("step-children");
        for (int i = 0; i < node.getChildCount(); ++i) {
            TreeNode childNode = node.getChildAt(i);
            IXMLElement step = this.buildSteps(childNode);
            childSteps.addChild(step);
        }
        String stepType = field.getAttribute("step-type");
        if (childSteps.getChildrenCount() > 0) {
            if (!"SPLIT_STEP".equals(stepType)) {
                CPEexport.addChildContent(rootStep, "step-type", "STEP_GROUP");
            } else {
                CPEexport.addChildContent(rootStep, "step-type", "SPLIT_STEP");
            }
            rootStep.addChild((IXMLElement)childSteps);
        } else if (stepType == null) {
            CPEexport.addChildContent(rootStep, "step-type", "SINGLE_STEP");
        } else {
            CPEexport.addChildContent(rootStep, "step-type", stepType);
        }
        return rootStep;
    }

    private IXMLElement createStepElement(IField field) {
        XMLElement step = new XMLElement("step");
        if (field == null) {
            return step;
        }
        String name = field.getAttribute("fieldName");
        if (name != null) {
            CPEexport.addChildContent((IXMLElement)step, "name", name);
        }
        this.addParameters(field, (IXMLElement)step);
        this.addNotes(field, (IXMLElement)step);
        this.addDataRefs(field, (IXMLElement)step);
        return step;
    }

    private void addNotes(IField field, IXMLElement step) {
        int noteCount = field.getNoteCount();
        if (noteCount == 0) {
            return;
        }
        XMLElement notes = new XMLElement("notes");
        for (int i = 0; i < noteCount; ++i) {
            XMLElement note = new XMLElement("note");
            Note noteData = field.getNoteAt(i);
            String name = noteData.getName();
            String content = noteData.getContent();
            CPEexport.addChildContent((IXMLElement)note, "name", name);
            CPEexport.addChildContent((IXMLElement)note, "content", content);
            notes.addChild((IXMLElement)note);
        }
        step.addChild((IXMLElement)notes);
    }

    private void addDataRefs(IField field, IXMLElement step) {
        int dRefCount = field.getDataRefCount();
        if (dRefCount == 0) {
            return;
        }
        XMLElement drefs = new XMLElement("data-references");
        for (int i = 0; i < dRefCount; ++i) {
            XMLElement ref = new XMLElement("data-reference");
            DataReference noteData = field.getDataRefAt(i);
            String attribute = noteData.getAttribute("name");
            CPEexport.addChildContent((IXMLElement)ref, "name", attribute);
            attribute = noteData.getAttribute("reference");
            CPEexport.addChildContent((IXMLElement)ref, "reference", attribute);
            attribute = noteData.getAttribute("description");
            CPEexport.addChildContent((IXMLElement)ref, "description", attribute);
            attribute = noteData.getAttribute("mime-type");
            CPEexport.addChildContent((IXMLElement)ref, "mime-type", attribute);
            attribute = noteData.getAttribute("size");
            CPEexport.addChildContent((IXMLElement)ref, "size", attribute);
            attribute = noteData.getAttribute("creation-time");
            CPEexport.addChildContent((IXMLElement)ref, "creation-time", attribute);
            attribute = noteData.getAttribute("modification-time");
            CPEexport.addChildContent((IXMLElement)ref, "modification-time", attribute);
            drefs.addChild((IXMLElement)ref);
        }
        step.addChild((IXMLElement)drefs);
    }

    private void addParameters(IField field, IXMLElement step) {
        int contentCount = field.getContentCount();
        String elementName = "parameter-list";
        if (field.getTableData() != null) {
            elementName = "parameter-table";
        }
        XMLElement params = new XMLElement(elementName);
        String stepDescription = "";
        for (int i = 0; i < contentCount; ++i) {
            IFieldContent content = field.getContentAt(i);
            if (content instanceof IParam) {
                IXMLElement parameter = this.createParamElement((IParam)content);
                params.addChild(parameter);
                String paramID = parameter.getFirstChildNamed("id").getContent();
                stepDescription = stepDescription + "[[" + paramID + "]]";
                continue;
            }
            stepDescription = stepDescription + ((Object)content).toString();
        }
        CPEexport.addChildContent(step, "description", stepDescription);
        if (params.getChildrenCount() > 0) {
            step.addChild((IXMLElement)params);
        }
    }

    private IXMLElement createParamElement(IParam param) {
        XMLElement parameter = new XMLElement("parameter");
        String name = param.getAttribute("paramName");
        if (name == null) {
            name = "param";
        }
        CPEexport.addChildContent((IXMLElement)parameter, "name", name);
        CPEexport.addChildContent((IXMLElement)parameter, "id", this.paramID++ + "");
        String paramDesc = param.getAttribute("paramDescription");
        boolean required = param.isAttributeTrue("paramRequired");
        String necessity = required ? "REQUIRED" : "OPTIONAL";
        CPEexport.addChildContent((IXMLElement)parameter, "necessity", necessity);
        if (param instanceof NumberParam) {
            CPEexport.addChildContent((IXMLElement)parameter, "param-type", "NUMERIC");
            this.setValueAndDefault((IXMLElement)parameter, param);
            String units = param.getAttribute("paramUnits");
            CPEexport.addChildContent((IXMLElement)parameter, "units", units);
        } else if (param instanceof EnumParam) {
            CPEexport.addChildContent((IXMLElement)parameter, "param-type", "ENUMERATION");
            this.setValueAndDefault((IXMLElement)parameter, param);
            String enumOptions = param.getAttribute("enumOptions");
            if (enumOptions != null) {
                XMLElement enumList = new XMLElement("enum-list");
                String[] options = enumOptions.split(",");
                for (int i = 0; i < options.length; ++i) {
                    CPEexport.addChildContent((IXMLElement)enumList, "enum", options[i].trim());
                }
                parameter.addChild((IXMLElement)enumList);
            }
            String units = param.getAttribute("paramUnits");
            CPEexport.addChildContent((IXMLElement)parameter, "units", units);
        } else if (param instanceof TextParam) {
            CPEexport.addChildContent((IXMLElement)parameter, "param-type", "TEXT");
            this.setValueAndDefault((IXMLElement)parameter, param);
        } else if (param instanceof TextBoxParam) {
            CPEexport.addChildContent((IXMLElement)parameter, "param-type", "TEXT");
            this.setValueAndDefault((IXMLElement)parameter, param);
            paramDesc = "Text Box: " + (paramDesc == null ? "" : paramDesc);
        } else if (param instanceof EditorLinkParam) {
            CPEexport.addChildContent((IXMLElement)parameter, "param-type", "TEXT");
            this.setValueAndDefault((IXMLElement)parameter, param);
            paramDesc = "Protocol Link: " + (paramDesc == null ? "" : paramDesc);
        } else if (param instanceof DateTimeParam) {
            CPEexport.addChildContent((IXMLElement)parameter, "param-type", "DATE_TIME");
            String ms = param.getAttribute("value");
            if (ms != null) {
                XMLElement data = new XMLElement("data");
                CPEexport.addChildContent((IXMLElement)data, "value", ms);
                parameter.addChild((IXMLElement)data);
            }
        } else if (param instanceof BooleanParam) {
            CPEexport.addChildContent((IXMLElement)parameter, "param-type", "ENUMERATION");
            this.setValueAndDefault((IXMLElement)parameter, param);
            XMLElement enumList = new XMLElement("enum-list");
            CPEexport.addChildContent((IXMLElement)enumList, "enum", "true");
            CPEexport.addChildContent((IXMLElement)enumList, "enum", "false");
            parameter.addChild((IXMLElement)enumList);
        } else if (param instanceof OntologyTermParam) {
            CPEexport.addChildContent((IXMLElement)parameter, "param-type", "TEXT");
            String value = param.getParamValue();
            if (value != null) {
                XMLElement data = new XMLElement("data");
                CPEexport.addChildContent((IXMLElement)data, "value", value);
                parameter.addChild((IXMLElement)data);
            }
            paramDesc = "Ontology Term: " + (paramDesc == null ? "" : paramDesc);
        } else {
            CPEexport.addChildContent((IXMLElement)parameter, "param-type", "TEXT");
            String value = param.getParamValue();
            XMLElement data = new XMLElement("data");
            if (value != null) {
                CPEexport.addChildContent((IXMLElement)data, "value", value);
                parameter.addChild((IXMLElement)data);
            }
        }
        CPEexport.addChildContent((IXMLElement)parameter, "description", paramDesc);
        return parameter;
    }

    private void setValueAndDefault(IXMLElement parameter, IParam param) {
        String defaultValue;
        int valCount = param.getValueCount();
        XMLElement data = new XMLElement("data");
        for (int i = 0; i < valCount; ++i) {
            Object v = param.getValueAt(i);
            String value = v == null ? "" : v + "";
            CPEexport.addChildContent((IXMLElement)data, "value", value);
        }
        if (valCount > 0) {
            parameter.addChild((IXMLElement)data);
        }
        if ((defaultValue = param.getAttribute("default-value")) != null) {
            CPEexport.addChildContent(parameter, "default-value", defaultValue);
        }
    }

    static void addChildContent(IXMLElement parent, String childName, String childContent) {
        if (parent == null) {
            return;
        }
        if (childName == null || childName.contains(" ") || childName.length() == 0) {
            return;
        }
        if (childContent == null) {
            return;
        }
        XMLElement child = new XMLElement(childName);
        child.setContent(childContent);
        parent.addChild((IXMLElement)child);
    }

    static IField getFieldFromTreeNode(TreeNode treeNode) {
        if (treeNode == null) {
            return null;
        }
        if (!(treeNode instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode dmNode = (DefaultMutableTreeNode)treeNode;
        Object userOb = dmNode.getUserObject();
        if (userOb instanceof IField) {
            IField field = (IField)userOb;
            return field;
        }
        return null;
    }

    public boolean export(TreeModel treeModel, File file) {
        XMLElement protocolArchive = new XMLElement("protocol-archive");
        XMLElement archiveInfo = new XMLElement("archive-info");
        CPEexport.addChildContent((IXMLElement)archiveInfo, "archive-version", "1.0");
        Date now = new Date();
        CPEexport.addChildContent((IXMLElement)archiveInfo, "archive-date", now.getTime() + "");
        CPEexport.addChildContent((IXMLElement)archiveInfo, "archive-creator", "OMERO.editor");
        CPEexport.addChildContent((IXMLElement)archiveInfo, "archive-type", "PROTOCOL_ARCHIVE");
        protocolArchive.addChild((IXMLElement)archiveInfo);
        XMLElement protocol = new XMLElement("protocol");
        protocolArchive.addChild((IXMLElement)protocol);
        XMLElement protocolInfo = new XMLElement("protocol-information");
        protocol.addChild((IXMLElement)protocolInfo);
        TreeNode root = (TreeNode)treeModel.getRoot();
        IField protocolRoot = CPEexport.getFieldFromTreeNode(root);
        protocolRoot.setAttribute("archive-date", now.getTime() + "");
        String protName = protocolRoot.getAttribute("fieldName");
        if (protName != null && protName.length() > 0) {
            CPEexport.addChildContent((IXMLElement)protocolInfo, "name", protName);
        }
        if (protocolRoot.getContentCount() > 0) {
            String desc = ((Object)protocolRoot.getContentAt(0)).toString();
            CPEexport.addChildContent((IXMLElement)protocolInfo, "description", desc);
        }
        String revision = protocolRoot.getAttribute("revision");
        CPEexport.addChildContent((IXMLElement)protocolInfo, "revision", revision);
        IAttributes eInfo = null;
        if (protocolRoot instanceof ProtocolRootField) {
            eInfo = ((ProtocolRootField)protocolRoot).getExpInfo();
        }
        if (eInfo != null) {
            String expDate = eInfo.getAttribute("experiment-date");
            String investigName = eInfo.getAttribute("investigator-name");
            XMLElement expInfo = new XMLElement("experiment-information");
            if (expDate == null) {
                expDate = now.getTime() + "";
            }
            if (investigName == null) {
                investigName = System.getProperty("user.name");
            }
            CPEexport.addChildContent((IXMLElement)expInfo, "experiment-date", expDate);
            CPEexport.addChildContent((IXMLElement)expInfo, "investigator-name", investigName);
            protocolInfo.addChild((IXMLElement)expInfo);
        }
        XMLElement steps = new XMLElement("steps");
        protocol.addChild((IXMLElement)steps);
        for (int i = 0; i < root.getChildCount(); ++i) {
            TreeNode childNode = root.getChildAt(i);
            IXMLElement step = this.buildSteps(childNode);
            steps.addChild(step);
        }
        try {
            FileWriter output = new FileWriter(file);
            output.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            if (this.cpeStyles != null) {
                output.write(this.cpeStyles + "\n");
            }
            output.write(this.cpeDtd + "\n");
            XMLWriter xmlwriter = new XMLWriter((Writer)output);
            xmlwriter.write((IXMLElement)protocolArchive, true);
        }
        catch (IOException e) {
            Registry reg = EditorAgent.getRegistry();
            reg.getLogger().error((Object)this, e.toString());
            UserNotifier un = reg.getUserNotifier();
            un.notifyInfo("File Failed to Save", "The file could not be saved for some reason. Try 'Save As...'");
            return false;
        }
        return true;
    }
}

