/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import org.openmicroscopy.shoola.agents.editor.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.AbstractParamEditor;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.ParamToolBar;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate.AttributeEditNoLabel;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate.ParamTemplateUIFactory;
import org.openmicroscopy.shoola.agents.editor.model.params.FieldParamsFactory;
import org.openmicroscopy.shoola.agents.editor.model.params.IParam;
import org.openmicroscopy.shoola.agents.editor.uiComponents.DropDownMenu;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ParamEditor
extends AbstractParamEditor
implements PropertyChangeListener {
    private PropertyChangeListener parent;
    private DropDownMenu paramTypeChooser;
    public static final String PARAM_TYPE = "paramType";
    private IParam parameter;

    private void initialise() {
        String[] options = FieldParamsFactory.getUiParamTypes();
        this.paramTypeChooser = new DropDownMenu(options);
        this.paramTypeChooser.addPropertyChangeListener("itemSelection", this);
    }

    private void buildUI() {
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(null);
        MatteBorder lineBorder = BorderFactory.createMatteBorder(1, 1, 1, 1, UIUtilities.LIGHT_GREY);
        this.setBorder(lineBorder);
        AttributeEditNoLabel nameEditor = new AttributeEditNoLabel(this.parameter, "paramName", "Parameter Name");
        nameEditor.addPropertyChangeListener("valueChangedProperty", this.parent);
        String paramType = this.parameter.getAttribute(PARAM_TYPE);
        if (paramType != null) {
            String[] paramTypes = FieldParamsFactory.getParamTypes();
            for (int i = 0; i < paramTypes.length; ++i) {
                if (!paramType.equals(paramTypes[i])) continue;
                this.paramTypeChooser.setSelectedIndex(i);
            }
        }
        ParamToolBar toolBars = new ParamToolBar(this.parameter);
        toolBars.addPropertyChangeListener(this.parent);
        EmptyBorder eb = new EmptyBorder(1, 4, 4, 4);
        JPanel nameAndTypeContainer = new JPanel(new BorderLayout());
        nameAndTypeContainer.setBackground(null);
        nameAndTypeContainer.setBorder(eb);
        nameAndTypeContainer.setOpaque(false);
        nameAndTypeContainer.add((Component)nameEditor, "Center");
        nameAndTypeContainer.add((Component)this.paramTypeChooser, "East");
        this.add(toolBars);
        this.add(nameAndTypeContainer);
        JComponent defaultEdit = ParamTemplateUIFactory.getEditDefaultComponent(this.parameter, this.controller);
        if (defaultEdit != null) {
            defaultEdit.setBorder(eb);
            this.add(defaultEdit);
            defaultEdit.addPropertyChangeListener("valueChangedProperty", this.parent);
            defaultEdit.addPropertyChangeListener("sizeChangedPropery", this);
        }
    }

    ParamEditor(IParam param, PropertyChangeListener parent, BrowserControl controller) {
        super(param);
        this.controller = controller;
        this.parameter = param;
        this.parent = parent;
        this.initialise();
        this.buildUI();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("sizeChangedPropery".equals(evt.getPropertyName())) {
            // empty if block
        }
        if ("itemSelection".equals(evt.getPropertyName())) {
            int selectedIndex = this.paramTypeChooser.getSelectedIndex();
            String newType = FieldParamsFactory.getParamTypes()[selectedIndex];
            this.firePropertyChange(PARAM_TYPE, null, newType);
        }
    }

    public IParam getParameter() {
        return this.parameter;
    }

    public String getEditDisplayName() {
        return "Edit Parameter Type";
    }
}

