/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.AbstractParamEditor;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.AttributeEditListeners;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomFont;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomLabel;

public class AttributeEditArea
extends AbstractParamEditor {
    private String attributeName;
    private String labelText;
    private JTextArea textBox;

    private void initialise() {
        String text = this.getParameter().getAttribute(this.attributeName);
        this.textBox = new JTextArea(text);
        this.textBox.setLineWrap(true);
        this.textBox.setFont(new CustomFont());
        this.textBox.setWrapStyleWord(true);
        Border bevelBorder = BorderFactory.createLoweredBevelBorder();
        Border emptyBorder = BorderFactory.createEmptyBorder(3, 3, 3, 3);
        CompoundBorder compoundBorder = BorderFactory.createCompoundBorder(bevelBorder, emptyBorder);
        this.textBox.setBorder(compoundBorder);
        AttributeEditListeners.addListeners(this.textBox, this, this.attributeName);
        this.textBox.getDocument().addDocumentListener(new NewLineListener());
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        this.add((Component)new CustomLabel(this.labelText + ": "), "North");
        this.add((Component)this.textBox, "Center");
    }

    public AttributeEditArea(IAttributes param, String attributeName, String label) {
        super(param);
        this.attributeName = attributeName;
        this.labelText = label;
        this.initialise();
        this.buildUI();
    }

    public AttributeEditArea(IAttributes param) {
        super(param);
        this.attributeName = "value";
        this.initialise();
        this.buildUI();
    }

    public void setCols(int cols) {
        this.textBox.setColumns(cols);
    }

    public JTextArea getTextArea() {
        return this.textBox;
    }

    public String getEditDisplayName() {
        return "Edit " + this.labelText;
    }

    public class NewLineListener
    implements DocumentListener {
        int lineCount;

        public NewLineListener() {
            this.lineCount = AttributeEditArea.this.textBox.getLineCount();
        }

        public void changedUpdate(DocumentEvent e) {
        }

        public void insertUpdate(DocumentEvent e) {
            this.checkLines();
        }

        public void removeUpdate(DocumentEvent e) {
            this.checkLines();
        }

        private void checkLines() {
            int newLineCount = AttributeEditArea.this.textBox.getLineCount();
            if (newLineCount != this.lineCount) {
                this.lineCount = newLineCount;
            }
        }
    }
}

