/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTree;
import javax.swing.tree.TreeNode;
import org.openmicroscopy.shoola.agents.editor.IconManager;
import org.openmicroscopy.shoola.agents.editor.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.uiComponents.PopupMenuButton;

public class AddParamActions {
    private IField field;
    private JTree tree;
    private TreeNode node;
    private BrowserControl controller;
    private JButton addParamButton;
    public static final String PARAM_ADDED_PROPERTY = "paramAddedProperty";
    private IconManager iM;

    private void initialise() {
        this.iM = IconManager.getInstance();
        Action[] actions = new Action[]{new AddTextParamAction(), new AddNumberParamAction(), new AddBooleanParamAction(), new AddEnumParamAction(), new AddDateTimeParamAction(), new AddEditorLinkParamAction(), new AddOntologyParamAction(), new AddDataRefAction()};
        Icon addIcon = this.iM.getIcon(13);
        this.addParamButton = new PopupMenuButton("Add parameter", addIcon, actions);
    }

    public AddParamActions(IField field, JTree tree, TreeNode node, BrowserControl controller) {
        this.field = field;
        this.tree = tree;
        this.node = node;
        this.controller = controller;
        this.initialise();
    }

    public JButton getButton() {
        return this.addParamButton;
    }

    public class AddEditorLinkParamAction
    extends AbstractAction {
        public AddEditorLinkParamAction() {
            this.putValue("Name", "Add Editor Link Parameter");
            this.putValue("ShortDescription", "Add a Parameter that links to another Editor file.");
            this.putValue("SmallIcon", AddParamActions.this.iM.getIcon(57));
        }

        public void actionPerformed(ActionEvent e) {
            AddParamActions.this.controller.addParamToField(AddParamActions.this.field, "editorLinkParam", AddParamActions.this.tree, AddParamActions.this.node);
        }
    }

    public class AddOntologyParamAction
    extends AbstractAction {
        public AddOntologyParamAction() {
            this.putValue("Name", "Add Ontology Parameter");
            this.putValue("ShortDescription", "Add an Ontology Term parameter to this field");
            this.putValue("SmallIcon", AddParamActions.this.iM.getIcon(65));
        }

        public void actionPerformed(ActionEvent e) {
            AddParamActions.this.controller.addParamToField(AddParamActions.this.field, "ONTOLOGYTERM", AddParamActions.this.tree, AddParamActions.this.node);
        }
    }

    public class AddDataRefAction
    extends AbstractAction {
        public AddDataRefAction() {
            this.putValue("Name", "Add Data Reference");
            this.putValue("ShortDescription", "Add a link to data");
            this.putValue("SmallIcon", AddParamActions.this.iM.getIcon(19));
        }

        public void actionPerformed(ActionEvent e) {
            AddParamActions.this.controller.addDataRefToField(AddParamActions.this.field, AddParamActions.this.tree, AddParamActions.this.node);
        }
    }

    public class AddDateTimeParamAction
    extends AbstractAction {
        public AddDateTimeParamAction() {
            this.putValue("Name", "Add Date-Time Parameter");
            this.putValue("ShortDescription", "Add a date-time parameter to this field");
            this.putValue("SmallIcon", AddParamActions.this.iM.getIcon(14));
        }

        public void actionPerformed(ActionEvent e) {
            AddParamActions.this.controller.addParamToField(AddParamActions.this.field, "DATE_TIME", AddParamActions.this.tree, AddParamActions.this.node);
        }
    }

    public class AddBooleanParamAction
    extends AbstractAction {
        public AddBooleanParamAction() {
            this.putValue("Name", "Add Checkbox Parameter");
            this.putValue("ShortDescription", "Add a checkbox parameter to this field");
            this.putValue("SmallIcon", AddParamActions.this.iM.getIcon(10));
        }

        public void actionPerformed(ActionEvent e) {
            AddParamActions.this.controller.addParamToField(AddParamActions.this.field, "BOOLEAN", AddParamActions.this.tree, AddParamActions.this.node);
        }
    }

    public class AddNumberParamAction
    extends AbstractAction {
        public AddNumberParamAction() {
            this.putValue("Name", "Add Number Parameter");
            this.putValue("ShortDescription", "Add a number parameter to this field");
            this.putValue("SmallIcon", AddParamActions.this.iM.getIcon(12));
        }

        public void actionPerformed(ActionEvent e) {
            AddParamActions.this.controller.addParamToField(AddParamActions.this.field, "NUMERIC", AddParamActions.this.tree, AddParamActions.this.node);
        }
    }

    public class AddEnumParamAction
    extends AbstractAction {
        public AddEnumParamAction() {
            this.putValue("Name", "Add Drop-down Menu Parameter");
            this.putValue("ShortDescription", "Add a number parameter to this field");
            this.putValue("SmallIcon", AddParamActions.this.iM.getIcon(11));
        }

        public void actionPerformed(ActionEvent e) {
            AddParamActions.this.controller.addParamToField(AddParamActions.this.field, "ENUMERATION", AddParamActions.this.tree, AddParamActions.this.node);
        }
    }

    public class AddTextParamAction
    extends AbstractAction {
        public AddTextParamAction() {
            this.putValue("Name", "Add Text Parameter");
            this.putValue("ShortDescription", "Add a text-line parameter to this field");
            this.putValue("SmallIcon", AddParamActions.this.iM.getIcon(3));
        }

        public void actionPerformed(ActionEvent e) {
            AddParamActions.this.controller.addParamToField(AddParamActions.this.field, "TEXT", AddParamActions.this.tree, AddParamActions.this.node);
        }
    }
}

