/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.paramUIs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.IconManager;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.AbstractParamEditor;
import org.openmicroscopy.shoola.agents.editor.model.params.IParam;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomButton;
import org.openmicroscopy.shoola.agents.editor.uiComponents.PopupMenuButton;
import org.openmicroscopy.shoola.agents.editor.uiComponents.RelativeFileChooser;
import org.openmicroscopy.shoola.agents.editor.util.BareBonesBrowserLaunch;
import org.openmicroscopy.shoola.agents.editor.util.FilePathMethods;
import org.openmicroscopy.shoola.agents.editor.util.PreferencesManager;
import org.openmicroscopy.shoola.util.filter.file.EditorFileFilter;

public class LinkEditor
extends AbstractParamEditor
implements ActionListener {
    private String URLlink;
    private int linkType;
    public static final int LOCAL_LINK = 0;
    public static final int RELATIVE_LINK = 1;
    public static final int URL_LINK = 2;
    public static final int LOCAL_EDITOR_LINK = 3;
    public static final int RELATIVE_EDITOR_LINK = 4;
    public static final int BROKEN_LINK = 5;
    private Icon linkLocalIcon;
    private Icon linkRelativeIcon;
    private Icon editorLinkIcon;
    private Icon editorRelativeLinkIcon;
    private Icon brokenLinkIcon;
    private Icon wwwIcon;
    private JButton linkButton;
    private JButton getLinkButton;

    private void initialise() {
        IconManager imF = IconManager.getInstance();
        this.linkLocalIcon = imF.getIcon(19);
        this.linkRelativeIcon = imF.getIcon(20);
        this.editorLinkIcon = imF.getIcon(21);
        this.editorRelativeLinkIcon = imF.getIcon(22);
        this.brokenLinkIcon = imF.getIcon(23);
        Icon chooseLinkIcon = imF.getIcon(24);
        this.wwwIcon = imF.getIcon(15);
        this.linkButton = new CustomButton();
        this.linkButton.addActionListener(this);
        this.linkButton.setCursor(new Cursor(12));
        this.linkButton.setForeground(Color.BLUE);
        Action[] getLinkActions = new Action[]{new GetURLAction(), new GetLinkPathAction()};
        this.getLinkButton = new PopupMenuButton("Choose a link to a URL or local file", chooseLinkIcon, getLinkActions);
    }

    private void buildUI() {
        this.add(this.linkButton);
        this.add(this.getLinkButton);
    }

    private void updateLink() {
        EditorFileFilter filter = new EditorFileFilter();
        if (this.URLlink != null) {
            File linkedFile = new File(this.URLlink);
            this.linkType = !linkedFile.exists() ? 5 : (((FileFilter)filter).accept(linkedFile) ? 3 : 0);
        } else if (this.URLlink != null) {
            File editorFile = null;
            if (editorFile == null) {
                this.linkType = 5;
                this.refreshLink();
                return;
            }
            this.URLlink = FilePathMethods.getAbsolutePathFromRelativePath(editorFile, this.URLlink);
            File linkedFile = new File(this.URLlink);
            this.linkType = !linkedFile.exists() ? 5 : (((FileFilter)filter).accept(linkedFile) ? 4 : 1);
        }
        if (this.URLlink == null) {
            this.linkType = 2;
        }
        this.refreshLink();
    }

    private void refreshLink() {
        if (this.URLlink == null) {
            this.linkButton.setText("");
            this.linkButton.setToolTipText("No link set");
            this.linkButton.setIcon(this.linkLocalIcon);
            this.linkButton.setEnabled(false);
            return;
        }
        int len = this.URLlink.length();
        this.linkButton.setText(len < 30 ? this.URLlink : "..." + this.URLlink.substring(len - 29, len));
        this.linkButton.setToolTipText("Open the link to: " + this.URLlink);
        this.linkButton.setEnabled(true);
        switch (this.linkType) {
            case 0: {
                this.linkButton.setIcon(this.linkLocalIcon);
                break;
            }
            case 1: {
                this.linkButton.setIcon(this.linkRelativeIcon);
                break;
            }
            case 3: {
                this.linkButton.setIcon(this.editorLinkIcon);
                break;
            }
            case 4: {
                this.linkButton.setIcon(this.editorRelativeLinkIcon);
                break;
            }
            case 2: {
                this.linkButton.setIcon(this.wwwIcon);
                break;
            }
            case 5: {
                this.linkButton.setIcon(this.brokenLinkIcon);
                this.linkButton.setEnabled(false);
                this.linkButton.setToolTipText("FILE NOT FOUND: " + this.URLlink);
            }
        }
    }

    private void getAndSaveLink() {
        String startDir = null;
        String currentFilePath = PreferencesManager.getPreference("currentImagesFolder");
        RelativeFileChooser relFileChooser = new RelativeFileChooser(null, startDir, currentFilePath);
        String linkedFilePath = relFileChooser.getPath();
        if (linkedFilePath == null) {
            return;
        }
    }

    public LinkEditor(IParam param) {
        super(param);
        this.initialise();
        this.buildUI();
        this.updateLink();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.linkType == 3) {
            File f = new File(this.URLlink);
            if (f.exists()) {
                EditorAgent.openLocalFile(f);
            }
        } else if (this.linkType != 4) {
            if (this.URLlink != null) {
                try {
                    new URL(this.URLlink);
                }
                catch (MalformedURLException ex) {
                    this.URLlink = System.getProperty("os.name").startsWith("Mac OS") ? "file://" + this.URLlink : "file:///" + this.URLlink;
                }
            }
            BareBonesBrowserLaunch.openURL(this.URLlink);
        }
    }

    public void attributeEdited(String attributeName, Object newValue) {
        super.attributeEdited(attributeName, newValue);
        this.firePropertyChange("sizeChangedPropery", null, null);
    }

    public String getEditDisplayName() {
        return "Edit Link";
    }

    private class GetLinkPathAction
    extends AbstractAction {
        public GetLinkPathAction() {
            this.putValue("Name", "Set Link to local file");
            this.putValue("ShortDescription", "Choose a file, that will be linked from this file");
            this.putValue("SmallIcon", LinkEditor.this.linkLocalIcon);
        }

        public void actionPerformed(ActionEvent e) {
            LinkEditor.this.getAndSaveLink();
        }
    }

    private class GetURLAction
    extends AbstractAction {
        public GetURLAction() {
            this.putValue("Name", "Set URL");
            this.putValue("ShortDescription", "Link to a web page");
            this.putValue("SmallIcon", LinkEditor.this.wwwIcon);
        }

        public void actionPerformed(ActionEvent e) {
            String url = (String)JOptionPane.showInputDialog(null, "Enter URL:", "Enter URL", -1, LinkEditor.this.wwwIcon, null, "http://");
            if (url == null || url.length() == 0) {
                return;
            }
            try {
                new URL(url);
            }
            catch (MalformedURLException ex) {
                url = "http://" + url;
            }
        }
    }
}

