/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser.actions;

import java.awt.event.ActionEvent;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEditSupport;
import org.openmicroscopy.shoola.agents.editor.browser.Browser;
import org.openmicroscopy.shoola.agents.editor.browser.actions.BrowserAction;
import org.openmicroscopy.shoola.agents.editor.browser.undo.UndoRedoListener;
import org.openmicroscopy.shoola.agents.editor.browser.undo.UndoRedoObservable;

public class RedoEditAction
extends BrowserAction
implements UndoableEditListener,
UndoRedoListener {
    private UndoManager undoManager;

    private void refreshStatus() {
        int state = this.model.getState();
        boolean enabled = state == 0 ? false : this.undoManager.canRedo();
        this.setEnabled(enabled);
        this.setDescription(enabled ? this.undoManager.getRedoPresentationName() : "Can't Redo");
    }

    public RedoEditAction(UndoManager undoManager, UndoableEditSupport undoSupport, Browser model) {
        super(model);
        this.undoManager = undoManager;
        if (undoManager instanceof UndoRedoObservable) {
            ((UndoRedoObservable)((Object)undoManager)).addUndoRedoListener(this);
        }
        this.setEnabled(undoManager.canRedo());
        undoSupport.addUndoableEditListener(this);
        this.setName("Redo");
        this.setIcon(48);
        this.refreshStatus();
    }

    protected void onStateChange() {
        this.refreshStatus();
    }

    public void actionPerformed(ActionEvent e) {
        if (this.undoManager.canRedo()) {
            this.undoManager.redo();
        }
    }

    public void undoableEditHappened(UndoableEditEvent e) {
        this.refreshStatus();
    }

    public void undoRedoPerformed() {
        this.refreshStatus();
    }
}

