/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.JViewport;
import javax.swing.Scrollable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.editor.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.editor.browser.FieldTextArea;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.TreeIterator;

public class TextAreasView
extends JPanel
implements Scrollable,
TreeModelListener,
TreeSelectionListener {
    private JTree navTree;
    private BrowserControl controller;
    private TreeModel treeModel;
    private Map<TreePath, FieldTextArea> textAreas;

    private void refreshTreeDisplay() {
        this.removeAll();
        this.textAreas.clear();
        if (this.treeModel != null) {
            Object r = this.treeModel.getRoot();
            if (!(r instanceof TreeNode)) {
                return;
            }
            TreeNode root = (TreeNode)r;
            TreeIterator iterator = new TreeIterator(root);
            while (iterator.hasNext()) {
                DefaultMutableTreeNode node;
                Object userOb;
                TreeNode tn = (TreeNode)iterator.next();
                if (!(tn instanceof DefaultMutableTreeNode) || !((userOb = (node = (DefaultMutableTreeNode)tn).getUserObject()) instanceof IField)) continue;
                IField f = (IField)userOb;
                TreePath path = new TreePath(node.getPath());
                if (f == null) continue;
                FieldTextArea tc = new FieldTextArea(f, this.navTree, node, this.controller);
                this.textAreas.put(path, tc);
                this.add(tc);
            }
        }
        JPanel spacer = new JPanel();
        spacer.setBackground(null);
        this.add(spacer);
        this.revalidate();
        this.repaint();
    }

    private void refreshSelection() {
        for (int i = 0; i < this.getComponentCount(); ++i) {
            JViewport scroller;
            Component comp = this.getComponent(i);
            if (comp instanceof FieldTextArea) {
                ((FieldTextArea)comp).refreshSelection();
            }
            if (this.navTree.getSelectionCount() == 0) {
                return;
            }
            TreePath path = this.navTree.getSelectionPath();
            JPanel selectedField = this.textAreas.get(path);
            if (selectedField == null) continue;
            Rectangle rect = selectedField.getBounds();
            int y = (int)rect.getY();
            if (!(this.getParent() instanceof JViewport) || (scroller = (JViewport)this.getParent()).getViewRect().contains(rect)) continue;
            scroller.setViewPosition(new Point(0, y));
        }
    }

    TextAreasView(JTree tree, BrowserControl controller) {
        this.navTree = tree;
        this.controller = controller;
        this.textAreas = new HashMap<TreePath, FieldTextArea>();
        if (this.navTree != null) {
            this.navTree.addTreeSelectionListener(this);
        }
        this.setLayout(new BoxLayout(this, 1));
        this.setBackground(Color.white);
        this.setBorder(new EmptyBorder(7, 7, 7, 7));
    }

    void setTreeModel(TreeModel treeModel) {
        this.treeModel = treeModel;
        if (treeModel != null) {
            treeModel.addTreeModelListener(this);
        }
        this.refreshTreeDisplay();
    }

    public Dimension getPreferredScrollableViewportSize() {
        return new Dimension(400, 200);
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return visibleRect.height;
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 10;
    }

    public void treeNodesChanged(TreeModelEvent e) {
        Object[] children = e.getChildren();
        if (children == null) {
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.treeModel.getRoot();
            TreePath path = new TreePath(root.getPath());
            FieldTextArea ta = this.textAreas.get(path);
            ta.refreshText();
            this.refreshSelection();
            return;
        }
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof DefaultMutableTreeNode)) continue;
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)children[i];
            TreePath path = new TreePath(node.getPath());
            FieldTextArea ta = this.textAreas.get(path);
            ta.refreshText();
        }
    }

    public void treeNodesInserted(TreeModelEvent e) {
        this.refreshTreeDisplay();
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        this.refreshTreeDisplay();
    }

    public void treeStructureChanged(TreeModelEvent e) {
        this.refreshTreeDisplay();
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.refreshSelection();
    }
}

