/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.IllegalComponentStateException;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyledDocument;
import javax.swing.text.html.HTML;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.editor.IconManager;
import org.openmicroscopy.shoola.agents.editor.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.editor.browser.HtmlContentEditor;
import org.openmicroscopy.shoola.agents.editor.browser.TextAreaFilter;
import org.openmicroscopy.shoola.agents.editor.browser.TextAreaNameFilter;
import org.openmicroscopy.shoola.agents.editor.browser.TextToken;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.ITreeEditComp;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.ParamEditorDialog;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.TextBoxEditor;
import org.openmicroscopy.shoola.agents.editor.model.DataReference;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.IFieldContent;
import org.openmicroscopy.shoola.agents.editor.model.TextBoxStep;
import org.openmicroscopy.shoola.agents.editor.model.TextContent;
import org.openmicroscopy.shoola.agents.editor.model.TreeModelMethods;
import org.openmicroscopy.shoola.agents.editor.model.params.FieldParamsFactory;
import org.openmicroscopy.shoola.agents.editor.model.params.IParam;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomButton;
import org.openmicroscopy.shoola.agents.editor.uiComponents.ImagePreview;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldTextArea
extends JPanel
implements FocusListener,
PropertyChangeListener,
ActionListener,
KeyListener {
    protected HtmlContentEditor contentEditor;
    protected HtmlContentEditor nameEditor;
    private static String addParamToolTip = "Add a parameter to this step";
    private IField field;
    private JTree navTree;
    private DefaultMutableTreeNode treeNode;
    protected BrowserControl controller;
    private JDialog paramEditDialog;
    protected Border selectedBorder;
    private Border unselectedBorder;
    private JButton addParamButton;
    private Icon addParamIcon;
    JButton notesButton;
    private Icon blankIcon;
    private JTextArea commentTextBox;
    private JPanel imagePanel;
    public static final String NAME_ID = "fieldname";
    public static final HTML.Tag TEXT_TAG = HTML.Tag.SPAN;
    public static final HTML.Tag PARAM_TAG = HTML.Tag.A;
    public static final HTML.Tag NAME_TAG = HTML.Tag.SPAN;
    public static final String TEXT_SPACER = "<" + TEXT_TAG + "> </" + TEXT_TAG + ">";

    private void initialise() {
        AbstractDocument doc;
        this.contentEditor = new HtmlContentEditor();
        this.contentEditor.addFocusListener(this);
        this.contentEditor.addKeyListener(this);
        this.contentEditor.addMouseListener(new ParamMouseListener());
        Document d = this.contentEditor.getDocument();
        if (d instanceof AbstractDocument && (doc = (AbstractDocument)d) instanceof StyledDocument) {
            doc.setDocumentFilter(new TextAreaFilter((StyledDocument)((Object)doc), HTML.Tag.A));
        }
        this.nameEditor = new HtmlContentEditor();
        this.nameEditor.addFocusListener(this);
        this.nameEditor.addKeyListener(this);
        d = this.nameEditor.getDocument();
        if (d instanceof AbstractDocument) {
            doc = (AbstractDocument)d;
            doc.setDocumentFilter(new TextAreaNameFilter());
        }
        int indent = 5 + this.treeNode.getLevel() * 14;
        EmptyBorder emptyBorder = new EmptyBorder(7, indent, 7, 7);
        Border lb = BorderFactory.createLineBorder(UIUtilities.LIGHT_GREY);
        this.selectedBorder = BorderFactory.createCompoundBorder(lb, emptyBorder);
        lb = BorderFactory.createLineBorder(Color.white);
        this.unselectedBorder = BorderFactory.createCompoundBorder(lb, emptyBorder);
        IconManager iM = IconManager.getInstance();
        this.addParamIcon = iM.getIcon(13);
        this.blankIcon = iM.getIcon(60);
        this.addParamButton = new CustomButton(this.addParamIcon);
        this.addParamButton.setToolTipText(addParamToolTip);
        this.addParamButton.addActionListener(this);
        Icon notesIcon = iM.getIcon(90);
        this.notesButton = new CustomButton(notesIcon);
        this.notesButton.setVisible(false);
    }

    private void buildUI() {
        this.setBackground(null);
        this.setLayout(new BorderLayout());
        Box titleToolBarBox = Box.createHorizontalBox();
        titleToolBarBox.add(this.nameEditor);
        titleToolBarBox.add(Box.createHorizontalGlue());
        this.refreshNotesVisibility();
        titleToolBarBox.add(this.notesButton);
        this.add((Component)titleToolBarBox, "North");
        this.add((Component)this.contentEditor, "Center");
        if (this.field instanceof TextBoxStep) {
            this.addParamButton.setVisible(false);
            IParam textBoxParam = ((TextBoxStep)this.field).getTextBoxParam();
            TextBoxEditor tbe = new TextBoxEditor(textBoxParam);
            this.commentTextBox = tbe.getTextBox();
            tbe.addPropertyChangeListener("valueChangedProperty", this);
            this.add((Component)tbe, "South");
        } else {
            this.imagePanel = new JPanel(new FlowLayout());
            this.imagePanel.setBackground(null);
            this.add((Component)this.imagePanel, "South");
        }
        JPanel buttonContainer = new JPanel(new BorderLayout());
        buttonContainer.setBackground(null);
        buttonContainer.add((Component)this.addParamButton, "North");
        this.add((Component)buttonContainer, "East");
        this.refreshText();
        this.setSelected(false);
    }

    private List<IFieldContent> getNewContent() {
        return this.getNewContent(null);
    }

    private List<IFieldContent> getNewContent(IFieldContent newParam) {
        int start = 0;
        int end = this.contentEditor.getDocument().getLength();
        return this.getNewContent(newParam, start, end);
    }

    private List<IFieldContent> getNewContent(IFieldContent newParam, int start, int end) {
        ArrayList<IFieldContent> contentList = new ArrayList<IFieldContent>();
        Document d = this.contentEditor.getDocument();
        int lastChar = start;
        int docEnd = end;
        List<TextToken> tags = this.contentEditor.getElementsByTag(PARAM_TAG);
        try {
            String description;
            for (TextToken param : tags) {
                String tagId;
                int tagStart = param.getStart();
                if (tagStart >= docEnd) continue;
                if (tagStart < lastChar) {
                    if (param.getEnd() <= lastChar) continue;
                    lastChar = param.getEnd();
                    continue;
                }
                description = d.getText(lastChar, tagStart - lastChar);
                if (description.trim().length() > 0) {
                    contentList.add(new TextContent(description));
                }
                if ("new".equals(tagId = param.getId()) && newParam != null) {
                    contentList.add(newParam);
                } else {
                    try {
                        int id = Integer.parseInt(param.getId());
                        if (id < this.field.getContentCount()) {
                            contentList.add(this.field.getContentAt(id));
                        }
                    }
                    catch (NumberFormatException ex) {
                        // empty catch block
                    }
                }
                lastChar = param.getEnd();
            }
            int remainingChars = docEnd - lastChar + 1;
            if (remainingChars > 0 && (description = d.getText(lastChar, remainingChars)).trim().length() > 0) {
                contentList.add(new TextContent(description));
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return contentList;
    }

    protected void showParamDialog(int index, Point point) {
        IFieldContent content;
        if (this.paramEditDialog != null && this.paramEditDialog.isVisible()) {
            this.paramEditDialog.setVisible(false);
            this.paramEditDialog.dispose();
        }
        if ((content = this.field.getContentAt(index)) instanceof IParam) {
            IParam param = (IParam)content;
            this.paramEditDialog = new ParamEditorDialog(param, point, this);
            this.paramEditDialog.setVisible(true);
        }
    }

    private boolean isFieldSelected() {
        if (this.treeNode == null) {
            return false;
        }
        if (this.navTree == null) {
            return false;
        }
        TreePath path = new TreePath(this.treeNode.getPath());
        return this.navTree.isPathSelected(path);
    }

    private void refreshNotesVisibility() {
        this.notesButton.setVisible(this.field.getNoteCount() > 0);
    }

    private void refreshDataRefs() {
        if (this.imagePanel == null) {
            return;
        }
        this.imagePanel.removeAll();
        int drCount = this.field.getDataRefCount();
        for (int i = 0; i < drCount; ++i) {
            String r = this.field.getDataRefAt(i).getAttribute("reference");
            if (!DataReference.showImage(r)) continue;
            this.imagePanel.add(new ImagePreview(r));
        }
    }

    private String getNameHtml() {
        String html = "";
        String name = this.getFieldName();
        if (name != null) {
            html = "<" + NAME_TAG + " " + HTML.Attribute.ID + "='" + NAME_ID + "'>" + name.trim() + "</" + NAME_TAG + "><br>";
        }
        return html;
    }

    private String getContentHtml() {
        String html = "";
        if (this.field.getContentCount() == 0) {
            String contentText = "<" + TEXT_TAG + " " + HTML.Attribute.ID + "='0'> </" + TEXT_TAG + ">";
            return html + contentText;
        }
        boolean includeSpacer = false;
        for (int i = 0; i < this.field.getContentCount(); ++i) {
            String contentText;
            IFieldContent content = this.field.getContentAt(i);
            if (content instanceof IParam) {
                String contentString = ((Object)content).toString();
                if (contentString.length() == 0) {
                    contentString = "param";
                }
                contentString = "[" + contentString + "]";
                contentText = (includeSpacer ? TEXT_SPACER : "") + "<" + PARAM_TAG + " href='#' " + HTML.Attribute.ID + "='" + i + "'>" + contentString + "</" + PARAM_TAG + ">";
                includeSpacer = true;
            } else {
                contentText = "<" + TEXT_TAG + " " + HTML.Attribute.ID + "='" + i + "'>" + ((Object)content).toString() + "</" + TEXT_TAG + ">";
                if (((Object)content).toString().length() > 0) {
                    includeSpacer = false;
                }
            }
            html = html + contentText;
        }
        return html;
    }

    protected void saveContent() {
        if (this.contentEditor.hasDataToSave()) {
            List<IFieldContent> newContent = this.getNewContent();
            this.saveContent(this.field, newContent, this.navTree, this.treeNode);
            this.contentEditor.dataSaved();
        }
    }

    protected void saveName() {
        String newName;
        String oldName = this.getFieldName();
        if (!oldName.equals(newName = this.getEditedName())) {
            this.saveName(this.field, newName, this.navTree, this.treeNode);
            this.nameEditor.dataSaved();
        }
    }

    protected void saveContent(IField fld, List<IFieldContent> content, JTree tree, TreeNode node) {
        this.controller.editFieldContent(fld, content, tree, node);
    }

    protected void saveName(IField fld, String name, JTree tree, TreeNode node) {
        this.controller.editAttribute(this.field, "fieldName", name, "Edit Name", tree, node);
    }

    private void splitField(int splitChar) {
        if (this.treeNode.isRoot()) {
            return;
        }
        String fieldName = this.getEditedName();
        int start = 0;
        int end = this.contentEditor.getDocument().getLength();
        List<IFieldContent> content1 = this.getNewContent(null, start, splitChar - 1);
        List<IFieldContent> content2 = this.getNewContent(null, splitChar, end);
        this.controller.splitField(this.field, fieldName, content1, content2, this.navTree, this.treeNode);
        this.contentEditor.dataSaved();
    }

    private void insertParam(String paramType) {
        String selectedText = this.contentEditor.getSelectedText();
        int start = this.contentEditor.getSelectionStart();
        int end = this.contentEditor.getSelectionEnd();
        Document d = this.contentEditor.getDocument();
        SimpleAttributeSet aAttributes = new SimpleAttributeSet();
        aAttributes.addAttribute(HTML.Attribute.ID, "new");
        SimpleAttributeSet tagAttributes = new SimpleAttributeSet();
        tagAttributes.addAttribute(PARAM_TAG, aAttributes);
        if (selectedText == null || selectedText.length() == 0) {
            selectedText = "param";
        }
        try {
            d.remove(start, end - start);
            if (start == 0) {
                ++start;
            }
            d.insertString(start, selectedText, tagAttributes);
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
        IParam param = FieldParamsFactory.getFieldParam(paramType);
        param.setAttribute("paramName", selectedText);
        List<IFieldContent> newContent = this.getNewContent(param);
        String fieldName = this.getEditedName();
        this.controller.editFieldContent(this.field, fieldName, newContent, this.navTree, this.treeNode);
        this.contentEditor.dataSaved();
    }

    private String getEditedName() {
        Document d = this.nameEditor.getDocument();
        String name = "";
        try {
            name = d.getText(0, d.getLength());
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return name.trim();
    }

    private void setSelected(boolean selected) {
        this.setBorder(selected ? this.selectedBorder : this.unselectedBorder);
        this.addParamButton.setIcon(selected ? this.addParamIcon : this.blankIcon);
        if (selected) {
            if (!this.contentEditor.hasFocus()) {
                this.nameEditor.removeFocusListener(this);
                this.nameEditor.requestFocusInWindow();
                int c = this.nameEditor.getCaretPosition();
                if (c == 0) {
                    int length = this.nameEditor.getDocument().getLength();
                    this.nameEditor.setSelectionStart(0);
                    this.nameEditor.setSelectionEnd(length - 1);
                }
                this.nameEditor.addFocusListener(this);
            }
            if (this.treeNode.isRoot()) {
                selected = false;
            }
        }
        this.addParamButton.setEnabled(selected);
    }

    public FieldTextArea(IField field, JTree tree, DefaultMutableTreeNode treeNode, BrowserControl controller) {
        this.field = field;
        this.navTree = tree;
        this.treeNode = treeNode;
        this.controller = controller;
        this.initialise();
        this.buildUI();
    }

    protected String getFieldName() {
        String name = this.field.getAttribute("fieldName");
        if (name == null || name.length() == 0) {
            name = TreeModelMethods.getNodeName(this.treeNode);
        }
        return name;
    }

    public void refreshText() {
        String content = this.getNameHtml();
        String html = "<html><head> <style type='text/css'> \nbody {font-weight: 500; font-family: arial} \n</style> </head> <body> " + content + " </body> </html>";
        this.nameEditor.setText(html);
        content = this.getContentHtml();
        html = "<html><body> " + content + " </body> </html>";
        this.contentEditor.setText(html);
        this.contentEditor.dataSaved();
        if (this.field instanceof TextBoxStep) {
            IParam textBoxParam = ((TextBoxStep)this.field).getTextBoxParam();
            String newText = textBoxParam.getAttribute("value");
            if (this.commentTextBox != null) {
                this.commentTextBox.setText(newText);
            }
        }
        this.refreshNotesVisibility();
        this.refreshDataRefs();
    }

    public void refreshSelection() {
        boolean selected = this.isFieldSelected();
        this.setSelected(selected);
        if (!selected && this.paramEditDialog != null) {
            this.paramEditDialog.dispose();
        }
        this.refreshNotesVisibility();
    }

    @Override
    public void focusGained(FocusEvent e) {
        if (this.treeNode == null) {
            return;
        }
        TreePath path = new TreePath(this.treeNode.getPath());
        if (this.navTree != null && !this.navTree.isPathSelected(path)) {
            this.navTree.setSelectionPath(path);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        Object source = e.getSource();
        if (source instanceof HtmlContentEditor) {
            if (source.equals(this.contentEditor)) {
                this.saveContent();
            } else if (source.equals(this.nameEditor)) {
                this.saveName();
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if ("valueChangedProperty".equals(propName) && evt.getSource() instanceof ITreeEditComp) {
            if (this.controller == null) {
                return;
            }
            ITreeEditComp src = (ITreeEditComp)evt.getSource();
            IAttributes param = src.getParameter();
            String attrName = src.getAttributeName();
            String displayName = src.getEditDisplayName();
            Object newVal = evt.getNewValue();
            if (newVal instanceof String || newVal == null) {
                String newValue = newVal == null ? null : newVal.toString();
                this.controller.editAttribute(param, attrName, newValue, displayName, this.navTree, this.treeNode);
            } else if (newVal instanceof HashMap) {
                HashMap newVals = (HashMap)newVal;
                this.controller.editAttributes(param, displayName, newVals, this.navTree, this.treeNode);
            }
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource().equals(this.addParamButton)) {
            this.insertParam("TEXT");
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (e.getKeyCode() == 10) {
            if (e.getSource().equals(this.contentEditor)) {
                int splitChar = this.contentEditor.getCaretPosition();
                this.splitField(splitChar);
            } else if (e.getSource().equals(this.nameEditor)) {
                this.contentEditor.setCaretPosition(1);
                this.contentEditor.requestFocusInWindow();
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
    }

    private class ParamMouseListener
    extends MouseAdapter {
        private ParamMouseListener() {
        }

        public void mouseClicked(MouseEvent e) {
            Point mouseLoc = e.getPoint();
            int c = FieldTextArea.this.contentEditor.viewToModel(mouseLoc);
            FieldTextArea.this.saveContent();
            if (FieldTextArea.this.contentEditor.isOffsetWithinTag(c, PARAM_TAG)) {
                FieldTextArea.this.addParamButton.setEnabled(false);
                String id = FieldTextArea.this.contentEditor.getElementId(c);
                if (id != null && FieldTextArea.this.isShowing()) {
                    Point paneLoc = null;
                    try {
                        paneLoc = FieldTextArea.this.getLocationOnScreen();
                        if (mouseLoc != null) {
                            paneLoc.translate((int)mouseLoc.getX(), (int)mouseLoc.getY());
                        }
                    }
                    catch (IllegalComponentStateException ex) {
                        ex.printStackTrace();
                    }
                    FieldTextArea.this.showParamDialog(Integer.parseInt(id), paneLoc);
                }
            } else {
                FieldTextArea.this.addParamButton.setEnabled(!FieldTextArea.this.treeNode.isRoot());
            }
        }
    }
}

