/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import org.openmicroscopy.shoola.agents.editor.IconManager;
import org.openmicroscopy.shoola.agents.editor.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.editor.browser.TreeOutlineCellRenderer;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.AbstractParamEditor;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.ITreeEditComp;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.ParamUIFactory;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.ParamValuesTable;
import org.openmicroscopy.shoola.agents.editor.model.FieldNode;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.IFieldContent;
import org.openmicroscopy.shoola.agents.editor.model.TextContent;
import org.openmicroscopy.shoola.agents.editor.model.TreeModelMethods;
import org.openmicroscopy.shoola.agents.editor.model.params.IParam;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.AddFieldTableEdit;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomButton;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomLabel;
import org.openmicroscopy.shoola.agents.editor.uiComponents.ImageBorderFactory;
import org.openmicroscopy.shoola.agents.editor.uiComponents.TableEditUI;
import org.openmicroscopy.shoola.agents.editor.uiComponents.UIUtilities;

public class FieldPanel
extends JPanel
implements PropertyChangeListener,
ActionListener {
    public static final String UPDATE_EDITING_PROPERTY = "sizeChangedPropery";
    public static final String NODE_CHANGED_PROPERTY = "nodeChangedProperty";
    public static final String TOGGLE_DESCRIPTION_CMD = "toggleDesc";
    public static final String LOAD_DEFAULTS_CMD = "loadDefaults";
    public static final String OPEN_URL_CMD = "openUrl";
    public static final String ADD_TABLE_CMD = "addFieldTable";
    public static final String REMOVE_TABLE_CMD = "removeFieldTable";
    private IField field;
    private BrowserControl controller;
    private JTree tree;
    private DefaultMutableTreeNode treeNode;
    private JPanel contentsPanel;
    private JLabel nameLabel;
    private Box horizontalBox;
    private JButton descriptionButton;
    private JButton fieldTableButton;
    private JLabel descriptionLabel;
    private IconManager iconManager;
    private boolean highlighted;
    private Color paintedColour;
    private Border imageBorder;
    private Border imageBorderHighlight;
    private static final int MAX_CHARS = 25;

    private void initialise() {
        this.iconManager = IconManager.getInstance();
        this.imageBorder = ImageBorderFactory.getImageBorder();
        this.imageBorderHighlight = ImageBorderFactory.getImageBorderHighLight();
        this.nameLabel = new CustomLabel();
        this.nameLabel.setBackground(null);
        this.nameLabel.setOpaque(false);
        this.descriptionLabel = new CustomLabel();
        this.descriptionLabel.setBackground(null);
        Icon infoIcon = this.iconManager.getIcon(45);
        this.descriptionButton = new CustomButton(infoIcon);
        this.descriptionButton.setFocusable(false);
        this.descriptionButton.setActionCommand(TOGGLE_DESCRIPTION_CMD);
        this.descriptionButton.addActionListener(this);
        this.descriptionButton.setVisible(false);
        this.setDescriptionText();
        Icon paramTableIcon = this.iconManager.getIcon(66);
        Icon removeTableIcon = this.iconManager.getIcon(70);
        this.fieldTableButton = new CustomButton();
        this.fieldTableButton.addActionListener(this);
        if (this.field.getTableData() == null) {
            this.fieldTableButton.setToolTipText("Add a table for parameter values, so that multiple values can be set for each parameter");
            this.fieldTableButton.setVisible(AddFieldTableEdit.canDo(this.field));
            this.fieldTableButton.setIcon(paramTableIcon);
            this.fieldTableButton.setActionCommand(ADD_TABLE_CMD);
        } else {
            this.fieldTableButton.setToolTipText("Remove table for parameter values");
            this.fieldTableButton.setIcon(removeTableIcon);
            this.fieldTableButton.setActionCommand(REMOVE_TABLE_CMD);
        }
    }

    private void buildUI() {
        this.setBorder(null);
        this.setBackground(null);
        this.setLayout(new BorderLayout());
        this.horizontalBox = Box.createHorizontalBox();
        this.horizontalBox.add(this.descriptionButton);
        this.horizontalBox.add(this.fieldTableButton);
        this.horizontalBox.add(Box.createHorizontalStrut(10));
        this.contentsPanel = new JPanel(new BorderLayout());
        this.contentsPanel.add((Component)this.nameLabel, "West");
        this.contentsPanel.add((Component)this.horizontalBox, "Center");
        this.contentsPanel.add((Component)this.descriptionLabel, "South");
        this.contentsPanel.setBorder(this.imageBorder);
        this.add((Component)this.contentsPanel, "Center");
    }

    private void buildParamComponents() {
        if (this.field.getTableData() != null) {
            ParamValuesTable table = new ParamValuesTable(this.field);
            TableEditUI tableUI = new TableEditUI(table);
            tableUI.addPropertyChangeListener(UPDATE_EDITING_PROPERTY, this);
            this.addFieldComponent(tableUI);
        } else {
            int paramCount = this.field.getContentCount();
            for (int i = 0; i < paramCount; ++i) {
                IParam param;
                AbstractParamEditor edit;
                IFieldContent content = this.field.getContentAt(i);
                if (!(content instanceof IParam) || (edit = ParamUIFactory.getEditingComponent(param = (IParam)content)) == null) continue;
                this.addFieldComponent(edit);
            }
        }
    }

    private void addFieldComponent(JComponent comp) {
        this.horizontalBox.add(Box.createHorizontalStrut(5));
        this.horizontalBox.add(comp);
        comp.addPropertyChangeListener(UPDATE_EDITING_PROPERTY, this);
        comp.addPropertyChangeListener("valueChangedProperty", this);
        comp.addPropertyChangeListener(NODE_CHANGED_PROPERTY, this);
    }

    private void refreshDefaultValue() {
    }

    private void setNameText() {
        String t = TreeOutlineCellRenderer.getFieldDisplayName(this.field, this.treeNode);
        this.nameLabel.setText(t);
    }

    private void setDescriptionText() {
        String description = this.getDescription();
        boolean showDesc = false;
        if (this.treeNode instanceof FieldNode) {
            showDesc = ((FieldNode)this.treeNode).getDescriptionVisisibility();
        }
        if (description != null && description.trim().length() > 0) {
            String htmlDescription = "<html><div style='width:250px; padding-left:30px;'>" + description + "</div></html>";
            this.descriptionButton.setToolTipText(htmlDescription);
            this.descriptionButton.setVisible(true);
            this.descriptionLabel.setVisible(showDesc);
            this.descriptionLabel.setFont(new Font("SansSerif", 0, 9));
            this.descriptionLabel.setText(htmlDescription);
        } else {
            this.descriptionButton.setToolTipText(null);
            this.descriptionButton.setVisible(false);
            this.descriptionLabel.setText(null);
            this.descriptionLabel.setVisible(false);
        }
    }

    private String getDescription() {
        if (this.field.getContentCount() == 0) {
            return null;
        }
        int contentCount = this.field.getContentCount();
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < contentCount; ++i) {
            IFieldContent content = this.field.getContentAt(i);
            if (content instanceof IParam) {
                boolean followedByText = false;
                for (int c = i; c < contentCount; ++c) {
                    if (!(this.field.getContentAt(c) instanceof TextContent)) continue;
                    followedByText = true;
                }
                if (!followedByText) continue;
                buf.append("[" + ((Object)content).toString() + "]");
                continue;
            }
            buf.append(((Object)content).toString());
        }
        String text = buf.toString();
        if (text.length() == 0) {
            return null;
        }
        return text;
    }

    private void refreshBackgroundColour() {
        this.paintedColour = FieldPanel.getColorFromString(this.field.getAttribute("backgroundColour"));
        if (this.paintedColour == null) {
            String ancestorColour = TreeModelMethods.getAttributeFromAncestor("backgroundColour", this.treeNode);
            this.paintedColour = FieldPanel.getColorFromString(ancestorColour);
        }
        this.refreshHighlighted();
    }

    private void refreshHighlighted() {
        if (this.highlighted) {
            this.contentsPanel.setBackground(this.paintedColour != null ? this.paintedColour : UIUtilities.BLUE_HIGHLIGHT);
            this.contentsPanel.setBorder(this.imageBorderHighlight);
        } else {
            this.contentsPanel.setBackground(this.paintedColour == null ? ImageBorderFactory.DEFAULT_BACKGROUND : this.paintedColour);
            this.contentsPanel.setBorder(this.imageBorder);
        }
    }

    private void loadDefaultValue() {
    }

    private void refreshEditingOfPanel() {
        if (this.tree != null && this.treeNode != null) {
            TreePath path = new TreePath(this.treeNode.getPath());
            this.tree.getUI().startEditingAtPath(this.tree, path);
        }
    }

    private void refreshPanel() {
        if (this.tree != null && this.treeNode != null) {
            DefaultTreeModel mod = (DefaultTreeModel)this.tree.getModel();
            mod.nodeChanged(this.treeNode);
        }
    }

    public FieldPanel(IField field, JTree tree, DefaultMutableTreeNode treeNode, BrowserControl controller) {
        this.field = field;
        this.tree = tree;
        this.treeNode = (FieldNode)treeNode;
        this.controller = controller;
        this.initialise();
        this.buildUI();
        this.setNameText();
        this.setDescriptionText();
        this.refreshBackgroundColour();
        this.refreshDefaultValue();
        this.buildParamComponents();
    }

    public void setSelected(boolean selected) {
        this.highlighted = selected;
        this.refreshHighlighted();
    }

    public static Color getColorFromString(String colourAttribute) {
        if (colourAttribute == null) {
            return null;
        }
        try {
            String[] rgb = colourAttribute.split(":");
            int red = Integer.parseInt(rgb[0]);
            int green = Integer.parseInt(rgb[1]);
            int blue = Integer.parseInt(rgb[2]);
            return new Color(red, green, blue);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (UPDATE_EDITING_PROPERTY.equals(propName)) {
            this.refreshEditingOfPanel();
        } else if (NODE_CHANGED_PROPERTY.equals(propName)) {
            this.refreshPanel();
        } else if ("valueChangedProperty".equals(propName) && evt.getSource() instanceof ITreeEditComp) {
            if (this.controller == null) {
                return;
            }
            ITreeEditComp src = (ITreeEditComp)evt.getSource();
            IAttributes param = src.getParameter();
            String attrName = src.getAttributeName();
            String displayName = src.getEditDisplayName();
            Object newVal = evt.getNewValue();
            if (newVal instanceof String || newVal == null) {
                String newValue = newVal == null ? null : newVal.toString();
                this.controller.editAttribute(param, attrName, newValue, displayName, this.tree, this.treeNode);
            } else if (newVal instanceof HashMap) {
                HashMap newVals = (HashMap)newVal;
                this.controller.editAttributes(param, displayName, newVals, this.tree, this.treeNode);
            }
        }
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (TOGGLE_DESCRIPTION_CMD.equals(cmd)) {
            if (this.treeNode instanceof FieldNode) {
                ((FieldNode)this.treeNode).toggleDescriptionVisibility();
            }
            this.refreshEditingOfPanel();
        } else if (LOAD_DEFAULTS_CMD.equals(cmd)) {
            this.loadDefaultValue();
        } else if (ADD_TABLE_CMD.equals(cmd)) {
            this.controller.addFieldTable(this.field, this.tree, this.treeNode);
        } else if (REMOVE_TABLE_CMD.equals(cmd)) {
            this.controller.removeFieldTable(this.field, this.tree, this.treeNode);
        }
    }
}

