/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import org.openmicroscopy.shoola.agents.editor.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate.FieldContentEditor;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.editTemplate.FieldParamEditor;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class FieldEditorDisplay
extends JPanel
implements TreeSelectionListener,
TreeModelListener,
PropertyChangeListener {
    private JTree tree;
    private BrowserControl controller;
    private JScrollPane scrollPane;
    private JComponent currentDisplay;
    private long id;

    private void setPanel() {
        this.setPanel(new JPanel());
    }

    private void setPanel(JComponent panel) {
        if (this.currentDisplay != null) {
            this.currentDisplay.removePropertyChangeListener("panelChanged", this);
        }
        this.currentDisplay = panel;
        this.currentDisplay.addPropertyChangeListener("panelChanged", this);
        this.scrollPane.setViewportView(this.currentDisplay);
        this.validate();
        this.repaint();
    }

    private void buildUI() {
        this.setLayout(new BorderLayout());
        this.scrollPane = new JScrollPane();
        this.scrollPane.setBackground(UIUtilities.BACKGROUND_COLOR);
        this.setMinimumSize(new Dimension(220, 220));
        this.scrollPane.setPreferredSize(new Dimension(250, 250));
        this.add((Component)this.scrollPane, "Center");
    }

    public FieldEditorDisplay(JTree tree, BrowserControl controller) {
        this.controller = controller;
        this.tree = tree;
        tree.addTreeSelectionListener(this);
        this.buildUI();
        this.setPanel();
    }

    void refreshEditorDisplay() {
        int editView = this.controller.getViewingMode();
        if (this.tree.getSelectionCount() == 1) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.tree.getSelectionPath().getLastPathComponent();
            IField field = (IField)node.getUserObject();
            FieldParamEditor fe = editView == 0 ? new FieldContentEditor(field, this.tree, node, this.controller) : new FieldParamEditor(field, this.tree, node, this.controller);
            fe.setId(this.id);
            this.setPanel(fe);
        } else {
            this.setPanel();
        }
    }

    void setId(long id) {
        this.id = id;
        if (this.currentDisplay != null && this.currentDisplay instanceof FieldParamEditor) {
            ((FieldParamEditor)this.currentDisplay).setId(id);
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.refreshEditorDisplay();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if ("panelChanged".equals(evt.getPropertyName())) {
            this.refreshEditorDisplay();
        }
    }

    public void treeNodesChanged(TreeModelEvent e) {
        this.refreshEditorDisplay();
    }

    public void treeNodesInserted(TreeModelEvent e) {
    }

    public void treeNodesRemoved(TreeModelEvent e) {
    }

    public void treeStructureChanged(TreeModelEvent e) {
    }
}

