/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jdesktop.swingx.JXDatePicker;
import org.openmicroscopy.shoola.agents.editor.IconManager;
import org.openmicroscopy.shoola.agents.editor.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.ITreeEditComp;
import org.openmicroscopy.shoola.agents.editor.browser.paramUIs.TextFieldEditor;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.ProtocolRootField;
import org.openmicroscopy.shoola.agents.editor.model.TreeIterator;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomButton;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomFont;
import org.openmicroscopy.shoola.agents.editor.uiComponents.CustomLabel;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

public class ExperimentInfoPanel
extends JPanel
implements TreeModelListener,
ActionListener,
TreeSelectionListener,
PropertyChangeListener {
    private JTree navTree;
    private BrowserControl controller;
    private TreeModel treeModel;
    TreeNode root;
    IAttributes field;
    private int unfilledParams;
    private int unfilledReqParams;
    private JLabel unfilledParamsLabel;
    private JLabel unfilledStepsLabel;
    private JTextField nameField;
    Box nameBox;
    private JXDatePicker datePicker;
    private JLabel lastModifiedLabel;
    private List<TreePath> unfilledSteps;
    private int currentStepIndex;
    private JButton nextStep;
    private JButton prevStep;
    private JButton goToFirstStep;
    public static final String NEXT_STEP = "nextStep";
    public static final String PREV_STEP = "prevStep";
    public static final String FIRST_STEP = "firstStep";
    public static final String DELETE_INFO = "deleteInfo";
    public static final Color LIGHT_YELLOW = new Color(254, 244, 156);

    private void initialise() {
        this.datePicker = UIUtilities.createDatePicker();
        this.datePicker.setFont((Font)new CustomFont());
        this.datePicker.addActionListener((ActionListener)this);
        this.unfilledParamsLabel = new CustomLabel();
        this.unfilledStepsLabel = new CustomLabel();
        this.unfilledStepsLabel.setAlignmentY(0.5f);
        IconManager iM = IconManager.getInstance();
        Icon rightIcon = iM.getIcon(85);
        Icon leftIcon = iM.getIcon(86);
        Icon goIcon = iM.getIcon(87);
        this.goToFirstStep = new CustomButton(goIcon);
        this.goToFirstStep.setActionCommand(FIRST_STEP);
        this.goToFirstStep.addActionListener(this);
        this.goToFirstStep.setFocusable(false);
        this.goToFirstStep.setToolTipText("Go to the first un-filled step");
        this.goToFirstStep.setAlignmentY(0.5f);
        this.nextStep = new CustomButton(rightIcon);
        this.nextStep.setActionCommand(NEXT_STEP);
        this.nextStep.addActionListener(this);
        this.nextStep.setFocusable(false);
        this.nextStep.setToolTipText("Go to the next un-filled step");
        this.nextStep.setAlignmentY(0.5f);
        this.prevStep = new CustomButton(leftIcon);
        this.prevStep.setActionCommand(PREV_STEP);
        this.prevStep.addActionListener(this);
        this.prevStep.setFocusable(false);
        this.prevStep.setToolTipText("Go to the previous un-filled step");
        this.prevStep.setAlignmentY(0.5f);
    }

    private void buildUI() {
        this.setVisible(false);
        this.setLayout(new BorderLayout());
        this.setBackground(LIGHT_YELLOW);
        MatteBorder lineBorder = BorderFactory.createMatteBorder(1, 1, 0, 1, UIUtilities.LIGHT_GREY.darker());
        this.setBorder(lineBorder);
        EmptyBorder eb = new EmptyBorder(5, 5, 5, 5);
        CustomLabel experiment = new CustomLabel("Experiment Info:");
        experiment.setBorder(eb);
        experiment.setFont(CustomFont.getFontBySize(14));
        JToolBar rightToolBar = new JToolBar();
        rightToolBar.setBackground(null);
        rightToolBar.setFloatable(false);
        MatteBorder bottomLeft = BorderFactory.createMatteBorder(0, 1, 1, 0, UIUtilities.LIGHT_GREY);
        rightToolBar.setBorder(bottomLeft);
        IconManager iM = IconManager.getInstance();
        Icon delete = iM.getIcon(84);
        CustomButton deleteButton = new CustomButton(delete);
        deleteButton.setFocusable(false);
        deleteButton.addActionListener(this);
        deleteButton.setActionCommand(DELETE_INFO);
        deleteButton.setToolTipText("<html>Remove Experiment Info:<br>This will also remove any experiment notes from each step.</html>");
        rightToolBar.add(deleteButton);
        Box titleToolBar = Box.createHorizontalBox();
        experiment.setAlignmentY(0.0f);
        titleToolBar.add(experiment);
        titleToolBar.add(Box.createHorizontalGlue());
        rightToolBar.setAlignmentY(0.0f);
        titleToolBar.add(rightToolBar);
        this.add((Component)titleToolBar, "North");
        JPanel leftPanel = new JPanel();
        leftPanel.setBorder(eb);
        leftPanel.setLayout(new BoxLayout(leftPanel, 1));
        leftPanel.setBackground(null);
        this.nameBox = Box.createHorizontalBox();
        this.nameBox.add(new CustomLabel("Investigator: "));
        this.nameBox.setAlignmentX(0.0f);
        leftPanel.add(this.nameBox);
        Box dateBox = Box.createHorizontalBox();
        CustomLabel dateLabel = new CustomLabel("Experiment Date: ");
        dateBox.add(dateLabel);
        dateBox.add((Component)this.datePicker);
        dateBox.setAlignmentX(0.0f);
        leftPanel.add(dateBox);
        this.lastModifiedLabel = new CustomLabel();
        this.lastModifiedLabel.setAlignmentX(0.0f);
        leftPanel.add(this.lastModifiedLabel);
        JPanel rightPanel = new JPanel();
        rightPanel.setBorder(eb);
        rightPanel.setLayout(new BoxLayout(rightPanel, 1));
        rightPanel.setBackground(null);
        Box stepButtonsBox = Box.createHorizontalBox();
        stepButtonsBox.add(this.unfilledStepsLabel);
        stepButtonsBox.add(this.prevStep);
        stepButtonsBox.add(this.goToFirstStep);
        stepButtonsBox.add(this.nextStep);
        stepButtonsBox.add(Box.createHorizontalGlue());
        stepButtonsBox.setAlignmentX(0.0f);
        this.unfilledParamsLabel.setAlignmentX(0.0f);
        rightPanel.add(this.unfilledParamsLabel);
        rightPanel.add(stepButtonsBox);
        this.add((Component)leftPanel, "West");
        this.add((Component)rightPanel, "East");
    }

    private void refreshPanel() {
        TreeNode tn = (TreeNode)this.treeModel.getRoot();
        if (!(tn instanceof DefaultMutableTreeNode)) {
            return;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)tn;
        Object userOb = node.getUserObject();
        if (!(userOb instanceof ProtocolRootField)) {
            return;
        }
        ProtocolRootField prf = (ProtocolRootField)userOb;
        this.field = prf.getExpInfo();
        if (this.field != null) {
            String expDate = this.field.getAttribute("experiment-date");
            String investigName = this.field.getAttribute("investigator-name");
            String lastModDate = prf.getAttribute("archive-date");
            String date = "no date";
            SimpleDateFormat f = new SimpleDateFormat("yyyy, MMM d");
            SimpleDateFormat timeStamp = new SimpleDateFormat("yyyy, MMM d 'at' HH:mm:ss");
            try {
                long millis = new Long(expDate);
                Date d = new Date(millis);
                this.datePicker.setDate(d);
                date = f.format(d);
                this.datePicker.setToolTipText(date);
                millis = new Long(lastModDate);
                d.setTime(millis);
                date = timeStamp.format(d);
                this.lastModifiedLabel.setText("Last edited: " + date);
            }
            catch (NumberFormatException ex) {
                this.lastModifiedLabel.setText("Last edited: " + date);
            }
            if (this.nameField == null) {
                TextFieldEditor nameEditor = new TextFieldEditor(this.field, "investigator-name");
                nameEditor.addPropertyChangeListener("valueChangedProperty", this);
                this.nameField = nameEditor.getTextField();
                this.nameBox.add(nameEditor);
            }
            this.nameField.setText(investigName);
            this.searchUnfilledParams();
            String paramText = "<b>" + this.unfilledParams + "</b> unfilled Parameters";
            if (this.unfilledReqParams > 0) {
                paramText = paramText + " <b style='color:red'>" + this.unfilledReqParams + " *required</b>";
            }
            this.unfilledParamsLabel.setText("<html>" + paramText + "</html>");
            this.unfilledStepsLabel.setText("<html>in <b>" + this.unfilledSteps.size() + "</b> steps.</html>");
            this.selectCurrentStep();
            this.setVisible(true);
        } else {
            this.setVisible(false);
        }
        this.revalidate();
        this.repaint();
    }

    private void searchUnfilledParams() {
        if (this.unfilledSteps == null) {
            this.unfilledSteps = new ArrayList<TreePath>();
        } else {
            this.unfilledSteps.clear();
        }
        this.unfilledParams = 0;
        this.unfilledReqParams = 0;
        this.currentStepIndex = -1;
        Object r = this.treeModel.getRoot();
        if (!(r instanceof TreeNode)) {
            return;
        }
        this.root = (TreeNode)r;
        TreeIterator iterator = new TreeIterator(this.root);
        while (iterator.hasNext()) {
            int paramCount;
            DefaultMutableTreeNode node;
            Object userOb;
            TreeNode tn = (TreeNode)iterator.next();
            if (!(tn instanceof DefaultMutableTreeNode) || !((userOb = (node = (DefaultMutableTreeNode)tn).getUserObject()) instanceof IField)) continue;
            IField f = (IField)userOb;
            TreePath path = new TreePath(node.getPath());
            if (f == null || (paramCount = f.getUnfilledCount()) <= 0) continue;
            this.unfilledParams += paramCount;
            this.unfilledSteps.add(path);
            paramCount = f.getUnfilledCount(true);
            if (paramCount <= 0) continue;
            this.unfilledReqParams += paramCount;
        }
    }

    private void selectCurrentStep() {
        if (this.unfilledSteps != null && this.currentStepIndex > -1 && this.currentStepIndex < this.unfilledSteps.size()) {
            TreePath currentStep = this.unfilledSteps.get(this.currentStepIndex);
            this.navTree.removeTreeSelectionListener(this);
            this.navTree.setSelectionPath(currentStep);
            this.navTree.addTreeSelectionListener(this);
        }
        this.refreshButtons();
    }

    private void refreshButtons() {
        if (this.currentStepIndex == -1) {
            this.goToFirstStep.setEnabled(true);
            this.nextStep.setEnabled(false);
            this.prevStep.setEnabled(false);
        } else {
            this.goToFirstStep.setEnabled(this.currentStepIndex != 0);
            this.prevStep.setEnabled(this.currentStepIndex > 0);
            this.nextStep.setEnabled(this.currentStepIndex < this.unfilledSteps.size() - 1);
        }
    }

    private void editAttribute(String attributeName, String newValue) {
        this.controller.editAttribute(this.field, attributeName, newValue, "Experiment", this.navTree, this.root);
    }

    ExperimentInfoPanel(JTree tree, BrowserControl controller) {
        this.navTree = tree;
        this.controller = controller;
        if (this.navTree != null) {
            this.navTree.addTreeSelectionListener(this);
        }
        this.initialise();
        this.buildUI();
    }

    void setTreeModel(TreeModel tm) {
        this.treeModel = tm;
        if (this.treeModel != null) {
            this.treeModel.addTreeModelListener(this);
        }
        this.refreshPanel();
    }

    public void treeNodesChanged(TreeModelEvent e) {
        this.refreshPanel();
    }

    public void treeNodesInserted(TreeModelEvent e) {
        this.refreshPanel();
    }

    public void treeNodesRemoved(TreeModelEvent e) {
        this.refreshPanel();
    }

    public void treeStructureChanged(TreeModelEvent e) {
        this.refreshPanel();
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        int stepCount = this.unfilledSteps.size();
        if (NEXT_STEP.equals(cmd)) {
            if (this.currentStepIndex < stepCount - 1) {
                ++this.currentStepIndex;
                this.selectCurrentStep();
            }
        } else if (PREV_STEP.equals(cmd)) {
            if (this.currentStepIndex > 0) {
                --this.currentStepIndex;
                this.selectCurrentStep();
            }
        } else if (FIRST_STEP.equals(cmd)) {
            if (stepCount > 0) {
                this.currentStepIndex = 0;
                this.selectCurrentStep();
            }
        } else if (DELETE_INFO.equals(cmd)) {
            this.controller.deleteExperimentInfo(this.navTree);
        } else if (e.getSource().equals(this.datePicker)) {
            String date = this.datePicker.getDate().getTime() + "";
            this.editAttribute("experiment-date", date);
        }
    }

    public void valueChanged(TreeSelectionEvent e) {
        this.currentStepIndex = -1;
        this.refreshButtons();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String property = evt.getPropertyName();
        if ("valueChangedProperty".equals(property) && evt.getSource() instanceof ITreeEditComp) {
            ITreeEditComp edit = (ITreeEditComp)evt.getSource();
            String attributeName = edit.getAttributeName();
            String newValue = evt.getNewValue().toString();
            this.editAttribute(attributeName, newValue);
        }
    }
}

