/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.tree.TreeNode;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.swing.undo.UndoableEditSupport;
import org.openmicroscopy.shoola.agents.editor.FileAnnotationLoader;
import org.openmicroscopy.shoola.agents.editor.browser.Browser;
import org.openmicroscopy.shoola.agents.editor.browser.BrowserUI;
import org.openmicroscopy.shoola.agents.editor.browser.actions.AddExpInfoAction;
import org.openmicroscopy.shoola.agents.editor.browser.actions.AddFieldAction;
import org.openmicroscopy.shoola.agents.editor.browser.actions.AddTextBoxFieldAction;
import org.openmicroscopy.shoola.agents.editor.browser.actions.ClearValuesAction;
import org.openmicroscopy.shoola.agents.editor.browser.actions.CopyFieldsAction;
import org.openmicroscopy.shoola.agents.editor.browser.actions.DeleteFieldsAction;
import org.openmicroscopy.shoola.agents.editor.browser.actions.EditAction;
import org.openmicroscopy.shoola.agents.editor.browser.actions.IndentLeftAction;
import org.openmicroscopy.shoola.agents.editor.browser.actions.IndentRightAction;
import org.openmicroscopy.shoola.agents.editor.browser.actions.MoveDownAction;
import org.openmicroscopy.shoola.agents.editor.browser.actions.MoveUpAction;
import org.openmicroscopy.shoola.agents.editor.browser.actions.PasteFieldsAction;
import org.openmicroscopy.shoola.agents.editor.browser.actions.RedoEditAction;
import org.openmicroscopy.shoola.agents.editor.browser.actions.UndoEditAction;
import org.openmicroscopy.shoola.agents.editor.browser.undo.ObservableUndoManager;
import org.openmicroscopy.shoola.agents.editor.browser.undo.UndoRedoListener;
import org.openmicroscopy.shoola.agents.editor.model.DataReference;
import org.openmicroscopy.shoola.agents.editor.model.IAttributes;
import org.openmicroscopy.shoola.agents.editor.model.IField;
import org.openmicroscopy.shoola.agents.editor.model.IFieldContent;
import org.openmicroscopy.shoola.agents.editor.model.Note;
import org.openmicroscopy.shoola.agents.editor.model.params.IParam;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.AddDataRefEdit;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.AddFieldTableEdit;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.AddParamEdit;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.AddStepNoteEdit;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.AttributeEdit;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.AttributesEdit;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.ChangeParamEdit;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.FieldContentEdit;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.FieldSplitEdit;
import org.openmicroscopy.shoola.agents.editor.model.undoableEdits.RemoveExpInfo;
import org.openmicroscopy.shoola.agents.editor.preview.AnnotationHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BrowserControl
implements ChangeListener,
UndoableEditListener,
UndoRedoListener {
    private int editingView;
    public static final int TREE_VIEW = 0;
    public static final int TEXT_VIEW = 1;
    static final Integer EDIT = 0;
    static final Integer UNDO_ACTION = 1;
    static final Integer REDO_ACTION = 2;
    static final Integer ADD_FIELD_ACTION = 3;
    static final Integer DELETE_FIELD_ACTION = 4;
    static final Integer INDENT_RIGHT_ACTION = 5;
    static final Integer INDENT_LEFT_ACTION = 6;
    static final Integer MOVE_UP_ACTION = 7;
    static final Integer MOVE_DOWN_ACTION = 8;
    static final Integer COPY_FIELDS_ACTION = 9;
    static final Integer PASTE_FIELDS_ACTION = 10;
    static final Integer ADD_TEXTBOX_FIELD_ACTION = 11;
    static final Integer ADD_EXP_INFO_ACTION = 12;
    static final Integer CLEAR_VALUES_ACTION = 13;
    private Browser model;
    private BrowserUI view;
    private Map<Integer, Action> actionsMap;
    private UndoManager undoManager;
    private UndoableEditSupport undoSupport;

    private void fileEdited() {
        this.model.setEdited(true);
    }

    private void createActions() {
        this.actionsMap.put(EDIT, new EditAction(this.model));
        this.actionsMap.put(UNDO_ACTION, new UndoEditAction(this.undoManager, this.undoSupport, this.model));
        this.actionsMap.put(REDO_ACTION, new RedoEditAction(this.undoManager, this.undoSupport, this.model));
        this.actionsMap.put(ADD_FIELD_ACTION, new AddFieldAction(this.undoSupport, this.model));
        this.actionsMap.put(DELETE_FIELD_ACTION, new DeleteFieldsAction(this.undoSupport, this.model));
        this.actionsMap.put(INDENT_RIGHT_ACTION, new IndentRightAction(this.undoSupport, this.model));
        this.actionsMap.put(INDENT_LEFT_ACTION, new IndentLeftAction(this.undoSupport, this.model));
        this.actionsMap.put(MOVE_UP_ACTION, new MoveUpAction(this.undoSupport, this.model));
        this.actionsMap.put(MOVE_DOWN_ACTION, new MoveDownAction(this.undoSupport, this.model));
        this.actionsMap.put(COPY_FIELDS_ACTION, new CopyFieldsAction(this.model));
        this.actionsMap.put(PASTE_FIELDS_ACTION, new PasteFieldsAction(this.undoSupport, this.model));
        this.actionsMap.put(ADD_TEXTBOX_FIELD_ACTION, new AddTextBoxFieldAction(this.undoSupport, this.model));
        this.actionsMap.put(ADD_EXP_INFO_ACTION, new AddExpInfoAction(this.undoSupport, this.model));
        this.actionsMap.put(CLEAR_VALUES_ACTION, new ClearValuesAction(this.undoSupport, this.model));
    }

    BrowserControl(Browser model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
        this.actionsMap = new HashMap<Integer, Action>();
        this.undoManager = new ObservableUndoManager();
        ((ObservableUndoManager)this.undoManager).addUndoRedoListener(this);
        this.undoSupport = new UndoableEditSupport();
        this.undoSupport.addUndoableEditListener(new UndoAdapter());
        this.undoSupport.addUndoableEditListener(this);
        this.createActions();
    }

    void initialize(BrowserUI view) {
        if (view == null) {
            throw new NullPointerException("No view.");
        }
        this.view = view;
        this.model.addChangeListener(this);
    }

    void setViewingMode(int viewMode) {
        switch (viewMode) {
            case 0: {
                this.editingView = 0;
                break;
            }
            case 1: {
                this.editingView = 1;
                break;
            }
        }
        this.stateChanged(new ChangeEvent(this));
    }

    int getViewingMode() {
        return this.editingView;
    }

    public Action getAction(Integer id) {
        return this.actionsMap.get(id);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.view.onStateChanged();
    }

    public boolean isModelExperiment() {
        return this.model.isModelExperiment();
    }

    public void editAttribute(IAttributes attributes, String name, String value, String displayName, JTree tree, TreeNode node) {
        AttributeEdit edit = new AttributeEdit(attributes, name, value, displayName, tree, node);
        this.undoSupport.postEdit(edit);
    }

    public void editAttributes(IAttributes attributes, String displayName, HashMap<String, String> newValues, JTree tree, TreeNode node) {
        AttributesEdit edit = new AttributesEdit(attributes, displayName, newValues, tree, node);
        this.undoSupport.postEdit(edit);
    }

    public void addParamToField(IField field, String paramType, JTree tree, TreeNode node) {
        AddParamEdit edit = new AddParamEdit(field, paramType, tree, node);
        this.undoSupport.postEdit(edit);
    }

    public void addDataRefToField(IField field, JTree tree, TreeNode node) {
        AddDataRefEdit edit = new AddDataRefEdit(field, tree, node);
        this.undoSupport.postEdit(edit);
    }

    public void addDataRefToField(IField field, DataReference dataRef, JTree tree, TreeNode node) {
        AddDataRefEdit edit = new AddDataRefEdit(field, dataRef, tree, node);
        this.undoSupport.postEdit(edit);
    }

    public void addParamToField(String text, IField field, JTree tree, TreeNode node) {
        AddParamEdit edit = new AddParamEdit(text, field, tree, node);
        this.undoSupport.postEdit(edit);
    }

    public void addStepNote(IField field, JTree tree, TreeNode node) {
        AddStepNoteEdit edit = new AddStepNoteEdit(field, tree, node);
        this.undoSupport.postEdit(edit);
    }

    public void deleteStepNote(IField field, JTree tree, TreeNode node, Note note) {
        AddStepNoteEdit edit = new AddStepNoteEdit(field, note, tree, node);
        this.undoSupport.postEdit(edit);
    }

    public void deleteExperimentInfo(JTree tree) {
        RemoveExpInfo edit = new RemoveExpInfo(tree);
        this.undoSupport.postEdit(edit);
    }

    public void splitField(IField field, String name, List<IFieldContent> content1, List<IFieldContent> content2, JTree tree, TreeNode node) {
        FieldSplitEdit edit = new FieldSplitEdit(field, name, content1, content2, tree, node);
        this.undoSupport.postEdit(edit);
    }

    public void editFieldContent(IField field, String name, List<IFieldContent> content, JTree tree, TreeNode node) {
        FieldContentEdit edit = new FieldContentEdit(field, name, content, tree, node);
        this.undoSupport.postEdit(edit);
    }

    public void editFieldContent(IField field, List<IFieldContent> content, JTree tree, TreeNode node) {
        FieldContentEdit edit = new FieldContentEdit(field, content, tree, node);
        this.undoSupport.postEdit(edit);
    }

    public void changeParam(IField field, IParam param, int index, JTree tree, TreeNode node) {
        ChangeParamEdit edit = new ChangeParamEdit(param, field, index, tree, node);
        this.undoSupport.postEdit(edit);
    }

    public void changeParam(IParam newParam, IParam oldParam, IField field, JTree tree, TreeNode node) {
        ChangeParamEdit edit = new ChangeParamEdit(newParam, oldParam, field, tree, node);
        this.undoSupport.postEdit(edit);
    }

    public void addFieldTable(IField field, JTree tree, TreeNode node) {
        AddFieldTableEdit edit = new AddFieldTableEdit(field, tree, node);
        this.undoSupport.postEdit(edit);
    }

    public void removeFieldTable(IField field, JTree tree, TreeNode node) {
        AddFieldTableEdit edit = new AddFieldTableEdit(field, tree, node, null);
        this.undoSupport.postEdit(edit);
    }

    public void getFileAnnotation(long fileID, AnnotationHandler handler) {
        if (handler == null) {
            return;
        }
        FileAnnotationLoader fal = new FileAnnotationLoader(this.model, fileID);
        fal.setAnnotationHandler(handler);
        fal.load();
    }

    @Override
    public void undoableEditHappened(UndoableEditEvent e) {
        this.fileEdited();
    }

    @Override
    public void undoRedoPerformed() {
        this.fileEdited();
    }

    private class UndoAdapter
    implements UndoableEditListener {
        private UndoAdapter() {
        }

        public void undoableEditHappened(UndoableEditEvent evt) {
            UndoableEdit edit = evt.getEdit();
            BrowserControl.this.undoManager.addEdit(edit);
        }
    }
}

