/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.browser;

import javax.swing.JComponent;
import javax.swing.tree.TreeModel;
import org.openmicroscopy.shoola.agents.editor.browser.Browser;
import org.openmicroscopy.shoola.agents.editor.browser.BrowserControl;
import org.openmicroscopy.shoola.agents.editor.browser.BrowserModel;
import org.openmicroscopy.shoola.agents.editor.browser.BrowserUI;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;

public class BrowserComponent
extends AbstractComponent
implements Browser {
    private BrowserModel model;
    private BrowserUI view;
    private BrowserControl controller;

    BrowserComponent(BrowserModel model) {
        this.model = model;
        this.controller = new BrowserControl(this);
        this.view = new BrowserUI();
    }

    void initialize() {
        this.model.initialize(this);
        this.controller.initialize(this.view);
        this.view.initialize(this.controller, this.model);
    }

    public void setTreeModel(TreeModel treeModel) {
        this.model.setTreeModel(treeModel);
        this.view.displayTree();
    }

    public TreeModel getTreeModel() {
        return this.model.getTreeModel();
    }

    public JComponent getUI() {
        return this.view;
    }

    public JComponent getToolBar() {
        return this.view.getToolBar();
    }

    public void setEdited(boolean edited) {
        this.model.setEdited(edited);
        this.fireStateChange();
        this.firePropertyChange("browserEdit", -1, this.model.getState());
    }

    public boolean isModelExperiment() {
        return this.model.isModelExperiment();
    }

    public void setId(long id) {
        this.model.setId(id);
        this.fireStateChange();
    }

    public int getState() {
        return this.model.getState();
    }
}

