/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor.actions;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JFrame;
import javax.swing.filechooser.FileFilter;
import org.openmicroscopy.shoola.agents.editor.EditorAgent;
import org.openmicroscopy.shoola.agents.editor.actions.ActionCmd;
import org.openmicroscopy.shoola.agents.editor.view.Editor;
import org.openmicroscopy.shoola.util.filter.file.CustomizedFileFilter;
import org.openmicroscopy.shoola.util.filter.file.EditorFileFilter;
import org.openmicroscopy.shoola.util.ui.MessageBox;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.filechooser.FileChooser;

public class SaveLocallyCmd
implements ActionCmd,
PropertyChangeListener {
    private Editor model;
    private List<FileFilter> filters;

    SaveLocallyCmd(Editor model) {
        if (model == null) {
            throw new IllegalArgumentException("No model.");
        }
        this.model = model;
        this.filters = new ArrayList<FileFilter>();
        this.filters.add(new EditorFileFilter());
    }

    public void execute() {
        FileChooser chooser = new FileChooser(null, 1, "Save File", "Choose a location and name to save the file", this.filters);
        File startDir = UIUtilities.getDefaultFolder();
        if (startDir != null) {
            chooser.setCurrentDirectory(startDir);
        }
        String text = this.model.getEditorTitle();
        if (this.model.isExperiment()) {
            text = text + "_exp";
        }
        chooser.setSelectedFile(new File(text));
        chooser.addPropertyChangeListener("approveSelection", this);
        UIUtilities.centerAndShow(chooser);
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (!(evt.getSource() instanceof FileChooser)) {
            return;
        }
        FileChooser fileChooser = (FileChooser)evt.getSource();
        String name = evt.getPropertyName();
        if ("approveSelection".equals(name)) {
            File file = (File)evt.getNewValue();
            FileFilter filter = fileChooser.getSelectedFilter();
            String filterExtension = "";
            if (filter instanceof CustomizedFileFilter) {
                filterExtension = ((CustomizedFileFilter)filter).getExtension();
            }
            if (!filter.accept(file)) {
                String filePath = file.getAbsolutePath();
                filePath = filePath + "." + filterExtension;
                file = new File(filePath);
            }
            if (file.exists()) {
                String title = "File Exists";
                String message = "File Exists. Overwrite Existing File?";
                JFrame f = EditorAgent.getRegistry().getTaskBar().getFrame();
                MessageBox msg = new MessageBox(f, title, message);
                int option = msg.centerMsgBox();
                if (option != 1) {
                    return;
                }
            }
            this.model.saveFileLocally(file);
        }
    }
}

