/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor;

import java.io.File;
import java.util.Map;
import org.openmicroscopy.shoola.agents.editor.EditorLoader;
import org.openmicroscopy.shoola.agents.editor.view.Editor;
import org.openmicroscopy.shoola.env.data.views.CallHandle;
import org.openmicroscopy.shoola.env.log.LogMessage;
import pojos.FileAnnotationData;

public class FileLoader
extends EditorLoader {
    private CallHandle handle;
    private long fileID;
    private long fileSize;
    private File file;

    public FileLoader(Editor viewer, String fileName, long fileID, long fileSize) {
        super(viewer);
        if (fileID < 0L) {
            throw new IllegalArgumentException("ID not valid.");
        }
        this.fileID = fileID;
        this.fileSize = fileSize;
        if (fileName != null) {
            this.file = new File(fileName);
        }
    }

    public void load() {
        this.handle = this.mhView.loadFile(this.file, this.fileID, this.fileSize, this);
    }

    public void cancel() {
        this.handle.cancel();
    }

    public void handleException(Throwable exc) {
        String s = "Data Retrieval Failure: ";
        LogMessage msg = new LogMessage();
        msg.print(s);
        msg.print(exc);
        this.registry.getLogger().error((Object)this, msg);
        this.registry.getUserNotifier().notifyInfo("Loading File.", "The specified file has not previously\nbeen saved or the passed ID is not valid.");
        this.viewer.discard();
    }

    public void handleResult(Object result) {
        if (this.viewer.getState() == 16) {
            return;
        }
        if (this.file == null) {
            Map m = (Map)result;
            for (Map.Entry entry : m.entrySet()) {
                FileAnnotationData fa = (FileAnnotationData)entry.getKey();
                File f = (File)entry.getValue();
                if (!f.exists()) continue;
                this.viewer.setFileToEdit(fa, f);
                f.delete();
            }
        } else {
            File f = (File)result;
            if (f.exists()) {
                this.viewer.setFileToEdit(null, f);
                String message = "Cannot delete the file.";
                if (f.delete()) {
                    message = "File deleted.";
                }
                this.registry.getLogger().info((Object)this, message);
                this.file.delete();
            }
        }
    }
}

