/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.editor;

import java.io.File;
import java.util.Map;
import java.util.Set;
import org.openmicroscopy.shoola.agents.editor.view.Editor;
import org.openmicroscopy.shoola.agents.editor.view.EditorFactory;
import org.openmicroscopy.shoola.agents.events.editor.CopyEvent;
import org.openmicroscopy.shoola.agents.events.editor.EditFileEvent;
import org.openmicroscopy.shoola.agents.events.editor.ShowEditorEvent;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.Agent;
import org.openmicroscopy.shoola.env.Environment;
import org.openmicroscopy.shoola.env.config.Registry;
import org.openmicroscopy.shoola.env.event.AgentEvent;
import org.openmicroscopy.shoola.env.event.AgentEventListener;
import org.openmicroscopy.shoola.env.event.EventBus;
import pojos.ExperimenterData;
import pojos.FileAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditorAgent
implements Agent,
AgentEventListener {
    private static Registry registry;

    public static Registry getRegistry() {
        return registry;
    }

    public static ExperimenterData getUserDetails() {
        return (ExperimenterData)registry.lookup("/current_user/details");
    }

    public static boolean isServerAvailable() {
        Environment env = (Environment)registry.lookup("/env");
        return env.isServerAvailable();
    }

    public static void openLocalFile(File file) {
        if (file == null) {
            return;
        }
        if (!file.exists()) {
            return;
        }
        Editor editor = EditorFactory.getEditor(file);
        if (editor != null) {
            if (editor.getState() == 1) {
                editor.setFileToEdit(null, file);
            }
            editor.activate();
        }
    }

    private void handleFileEdition(EditFileEvent event) {
        if (event == null) {
            return;
        }
        Editor editor = null;
        FileAnnotationData data = event.getFileAnnotation();
        if (data == null) {
            if (event.getFileAnnotationID() > 0L) {
                editor = EditorFactory.getEditor(event.getFileAnnotationID());
            }
        } else {
            String name = data.getFileName();
            if (name == null) {
                return;
            }
            if (!EditorUtil.isEditorFile(name)) {
                return;
            }
            editor = EditorFactory.getEditor(data);
        }
        if (editor != null) {
            editor.activate();
        }
    }

    private void handleShowEditor(ShowEditorEvent evt) {
        Editor editor = null;
        if (evt == null) {
            editor = EditorFactory.getEditor();
            if (editor != null) {
                editor.activate();
            }
            return;
        }
        if (evt.getParent() == null) {
            editor = EditorFactory.getEditor();
        } else {
            int editorType = 100;
            if (evt.getType() == 0) {
                editorType = 101;
            }
            editor = EditorFactory.getEditor(evt.getParent(), evt.getName(), editorType);
        }
        if (editor != null) {
            editor.activate();
        }
    }

    private void handleCopyData(CopyEvent evt) {
        EditorFactory.setCopiedData(evt.getCopiedData());
    }

    @Override
    public void activate() {
        if (!EditorAgent.isServerAvailable()) {
            this.handleShowEditor(null);
        }
    }

    @Override
    public void terminate() {
    }

    @Override
    public void setContext(Registry ctx) {
        registry = ctx;
        EventBus bus = registry.getEventBus();
        bus.register((AgentEventListener)this, EditFileEvent.class);
        bus.register((AgentEventListener)this, ShowEditorEvent.class);
        bus.register((AgentEventListener)this, CopyEvent.class);
    }

    @Override
    public boolean canTerminate() {
        return true;
    }

    @Override
    public Map<String, Set> hasDataToSave() {
        return null;
    }

    @Override
    public void eventFired(AgentEvent e) {
        if (e instanceof EditFileEvent) {
            this.handleFileEdition((EditFileEvent)e);
        } else if (e instanceof ShowEditorEvent) {
            this.handleShowEditor((ShowEditorEvent)e);
        } else if (e instanceof CopyEvent) {
            this.handleCopyData((CopyEvent)e);
        }
    }
}

