/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserTranslator;
import org.openmicroscopy.shoola.agents.dataBrowser.ThumbnailLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.CellDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserModel;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.util.image.geom.Factory;
import pojos.DataObject;
import pojos.ImageData;
import pojos.WellData;
import pojos.WellSampleData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class WellsModel
extends DataBrowserModel {
    private int rows;
    private int columns;
    private Dimension wellDimension;
    private List wellNodes;
    private Set<CellDisplay> cells;
    private int fieldsNumber;
    private int selectedField;

    private List sortByRow(Set nodes) {
        ArrayList l = new ArrayList();
        if (nodes == null) {
            return l;
        }
        Iterator i = nodes.iterator();
        while (i.hasNext()) {
            l.add(i.next());
        }
        Comparator c = new Comparator(){

            public int compare(Object o1, Object o2) {
                WellData w1 = (WellData)((WellImageSet)o1).getHierarchyObject();
                WellData w2 = (WellData)((WellImageSet)o2).getHierarchyObject();
                int n1 = w1.getRow();
                int n2 = w2.getRow();
                int v = 0;
                if (n1 < n2) {
                    v = -1;
                } else if (n1 > n2) {
                    v = 1;
                } else if (n1 == n2) {
                    int c2;
                    int c1 = w1.getColumn();
                    if (c1 < (c2 = w2.getColumn().intValue())) {
                        v = -1;
                    } else if (c1 > c2) {
                        v = 1;
                    }
                }
                return v;
            }
        };
        Collections.sort(l, c);
        return l;
    }

    WellsModel(Object parent, Set<WellData> wells) {
        CellDisplay cell;
        int k;
        if (wells == null) {
            throw new IllegalArgumentException("No wells.");
        }
        this.wellDimension = null;
        this.parent = parent;
        long userID = DataBrowserAgent.getUserDetails().getId();
        Set nodes = DataBrowserTranslator.transformHierarchy(wells, userID, 0L);
        this.wellNodes = this.sortByRow(nodes);
        HashSet<ImageNode> samples = new HashSet<ImageNode>();
        this.cells = new HashSet<CellDisplay>();
        this.rows = -1;
        this.columns = -1;
        Iterator j = this.wellNodes.iterator();
        int f = -1;
        while (j.hasNext()) {
            WellImageSet node = (WellImageSet)j.next();
            int row = node.getRow();
            int column = node.getColumn();
            if (row > this.rows) {
                this.rows = row;
            }
            if (column > this.columns) {
                this.columns = column;
            }
            node.setCellDisplay("" + (column + 1), EditorUtil.LETTERS.get(row + 1));
            f = node.getNumberOfSamples();
            if (this.fieldsNumber < f) {
                this.fieldsNumber = f;
            }
            ImageNode selected = node.getSelectedWellSample();
            samples.add(selected);
            if (((DataObject)selected.getHierarchyObject()).getId() < 0L || this.wellDimension != null) continue;
            this.wellDimension = selected.getThumbnail().getOriginalSize();
        }
        ++this.columns;
        ++this.rows;
        for (k = 1; k <= this.columns; ++k) {
            cell = new CellDisplay(k - 1, "" + k);
            samples.add(cell);
            this.cells.add(cell);
        }
        for (k = 1; k <= this.rows; ++k) {
            cell = new CellDisplay(k - 1, EditorUtil.LETTERS.get(k), 0);
            samples.add(cell);
            this.cells.add(cell);
        }
        this.browser = BrowserFactory.createBrowser(samples);
        this.layoutBrowser(3);
    }

    int getFieldsNumber() {
        return this.fieldsNumber;
    }

    int getSelectedField() {
        return this.selectedField;
    }

    void viewField(int index) {
        if (index < 0 || index >= this.fieldsNumber) {
            return;
        }
        this.selectedField = index;
        HashSet<ImageDisplay> samples = new HashSet<ImageDisplay>();
        List<ImageDisplay> l = this.getNodes();
        for (WellImageSet wellImageSet : l) {
            wellImageSet.setSelectedWellSample(index);
            samples.add(wellImageSet.getSelectedWellSample());
        }
        samples.addAll(this.cells);
        this.browser.refresh(samples);
        this.layoutBrowser(3);
    }

    @Override
    protected DataBrowserLoader createDataLoader(boolean refresh, Collection ids) {
        List<ImageDisplay> l = this.getNodes();
        Iterator<ImageDisplay> i = l.iterator();
        ArrayList<ImageData> images = new ArrayList<ImageData>();
        while (i.hasNext()) {
            ImageSet node = (ImageSet)i.next();
            if (!(node instanceof WellImageSet)) continue;
            ImageNode selected = ((WellImageSet)node).getSelectedWellSample();
            WellSampleData data = (WellSampleData)selected.getHierarchyObject();
            if (data.getId() < 0L) {
                selected.getThumbnail().setFullScaleThumb(Factory.createDefaultImageThumbnail(this.wellDimension.width, this.wellDimension.height));
                continue;
            }
            images.add(data.getImage());
        }
        if (images.size() == 0) {
            return null;
        }
        return new ThumbnailLoader(this.component, images);
    }

    @Override
    protected int getType() {
        return 5;
    }

    @Override
    protected List<ImageDisplay> getNodes() {
        return this.wellNodes;
    }
}

