/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserTranslator;
import org.openmicroscopy.shoola.agents.dataBrowser.ThumbnailLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserModel;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.ProjectData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TagsModel
extends DataBrowserModel {
    private Set<DataObject> dataObjects;

    TagsModel(Object parent, Set<DataObject> dataObjects, boolean withImages) {
        if (dataObjects == null) {
            throw new IllegalArgumentException("No dataObjects.");
        }
        this.dataObjects = dataObjects;
        this.parent = parent;
        long userID = DataBrowserAgent.getUserDetails().getId();
        Set visTrees = withImages ? DataBrowserTranslator.transformHierarchy(dataObjects, userID, 0L) : DataBrowserTranslator.transformImages(dataObjects, userID, 0L);
        this.browser = BrowserFactory.createBrowser(visTrees);
        this.layoutBrowser();
        ArrayList<Long> ids = new ArrayList<Long>();
        for (ImageDisplay node : visTrees) {
            Set datasets;
            Set images;
            Object object = node.getHierarchyObject();
            if (object instanceof ImageData) {
                ids.add(((ImageData)object).getId());
                continue;
            }
            if (object instanceof DatasetData) {
                images = ((DatasetData)object).getImages();
                if (images == null) continue;
                for (ImageData img : images) {
                    if (ids.contains(img.getId())) continue;
                    ids.add(img.getId());
                }
                continue;
            }
            if (!(object instanceof ProjectData) || (datasets = ((ProjectData)object).getDatasets()) == null) continue;
            Iterator j = datasets.iterator();
            while (j.hasNext()) {
                images = ((DatasetData)j.next()).getImages();
                if (images == null) continue;
                for (ImageData img : images) {
                    if (ids.contains(img.getId())) continue;
                    ids.add(img.getId());
                }
            }
        }
        this.numberOfImages = ids.size();
    }

    @Override
    protected DataBrowserLoader createDataLoader(boolean refresh, Collection ids) {
        if (refresh) {
            this.imagesLoaded = 0;
        }
        if (this.imagesLoaded != 0 && ids != null) {
            this.imagesLoaded -= ids.size();
        }
        if (this.imagesLoaded == this.numberOfImages) {
            return null;
        }
        List<ImageNode> nodes = this.browser.getVisibleImageNodes();
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        Iterator<ImageNode> i = nodes.iterator();
        ArrayList<ImageData> imgs = new ArrayList<ImageData>();
        ArrayList<Long> loaded = new ArrayList<Long>();
        if (ids != null) {
            while (i.hasNext()) {
                ImageData img;
                ImageNode node = i.next();
                if (node.getThumbnail().getFullScaleThumb() != null || !ids.contains((img = (ImageData)node.getHierarchyObject()).getId()) || loaded.contains(img.getId())) continue;
                imgs.add(img);
                loaded.add(img.getId());
                ++this.imagesLoaded;
            }
        } else {
            while (i.hasNext()) {
                ImageData img;
                ImageNode node = i.next();
                if (node.getThumbnail().getFullScaleThumb() != null || loaded.contains((img = (ImageData)node.getHierarchyObject()).getId())) continue;
                imgs.add(img);
                loaded.add(img.getId());
                ++this.imagesLoaded;
            }
        }
        if (imgs.size() == 0) {
            return null;
        }
        return new ThumbnailLoader(this.component, this.sorter.sort(imgs));
    }

    @Override
    protected int getType() {
        return 4;
    }

    @Override
    protected List<ImageDisplay> getNodes() {
        return null;
    }
}

