/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserTranslator;
import org.openmicroscopy.shoola.agents.dataBrowser.ThumbnailLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.BrowserFactory;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserModel;
import pojos.DataObject;
import pojos.ImageData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SearchModel
extends DataBrowserModel {
    private Collection<DataObject> results;

    SearchModel(Collection<DataObject> results) {
        if (results == null) {
            throw new IllegalArgumentException("No results.");
        }
        this.results = results;
        this.numberOfImages = results.size();
        long userID = DataBrowserAgent.getUserDetails().getId();
        Set visTrees = DataBrowserTranslator.transformObjects(results, userID, 0L);
        this.browser = BrowserFactory.createBrowser(visTrees);
        this.layoutBrowser();
    }

    @Override
    protected DataBrowserLoader createDataLoader(boolean refresh, Collection ids) {
        if (refresh) {
            this.imagesLoaded = 0;
        }
        if (this.imagesLoaded != 0 && ids != null) {
            this.imagesLoaded -= ids.size();
        }
        if (this.imagesLoaded == this.numberOfImages) {
            return null;
        }
        List<ImageNode> nodes = this.browser.getVisibleImageNodes();
        if (nodes == null || nodes.size() == 0) {
            return null;
        }
        Iterator<ImageNode> i = nodes.iterator();
        ArrayList<ImageData> imgs = new ArrayList<ImageData>();
        if (ids != null) {
            while (i.hasNext()) {
                ImageNode node = i.next();
                ImageData img = (ImageData)node.getHierarchyObject();
                if (!ids.contains(img.getId()) || node.getThumbnail().getFullScaleThumb() != null) continue;
                imgs.add((ImageData)node.getHierarchyObject());
                ++this.imagesLoaded;
            }
        } else {
            while (i.hasNext()) {
                ImageNode node = i.next();
                if (node.getThumbnail().getFullScaleThumb() != null) continue;
                imgs.add((ImageData)node.getHierarchyObject());
                ++this.imagesLoaded;
            }
        }
        return new ThumbnailLoader(this.component, this.sorter.sort(imgs));
    }

    @Override
    protected int getType() {
        return 3;
    }

    @Override
    protected List<ImageDisplay> getNodes() {
        return null;
    }
}

