/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JPanel;
import javax.swing.JToolBar;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserControl;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserUI;
import org.openmicroscopy.shoola.util.ui.UIUtilities;

class DataBrowserWellToolBar
extends JPanel {
    private DataBrowserControl controller;
    private DataBrowserUI view;
    private JButton refreshButton;
    private JComboBox fields;

    private void initComponents() {
        this.refreshButton = new JButton(this.controller.getAction(DataBrowserControl.REFRESH));
        UIUtilities.unifiedButtonLookAndFeel(this.refreshButton);
        int f = this.view.getFieldsNumber();
        if (f > 1) {
            String[] values = new String[f];
            for (int i = 0; i < f; ++i) {
                values[i] = "Field #" + i;
            }
            this.fields = new JComboBox<String>(values);
            this.fields.setSelectedIndex(this.view.getSelectedField());
            this.fields.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    DataBrowserWellToolBar.this.controller.viewField(DataBrowserWellToolBar.this.fields.getSelectedIndex());
                }
            });
        }
    }

    private JToolBar buildViewsBar() {
        JToolBar bar = new JToolBar();
        bar.setFloatable(false);
        bar.setBorder(null);
        bar.setRollover(true);
        bar.add(this.refreshButton);
        if (this.fields != null) {
            bar.add(this.fields);
        }
        return bar;
    }

    private void buildGUI() {
        JPanel content = new JPanel();
        content.setLayout(new BoxLayout(content, 1));
        JPanel p = new JPanel();
        p.add(this.buildViewsBar());
        content.add(p);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.add(content);
    }

    DataBrowserWellToolBar(DataBrowserUI view, DataBrowserControl controller) {
        if (controller == null) {
            throw new IllegalArgumentException("No control.");
        }
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        this.controller = controller;
        this.view = view;
        this.initComponents();
        this.buildGUI();
    }
}

