/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.FlowLayout;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserUI;
import org.openmicroscopy.shoola.util.ui.slider.OneKnobSlider;

class DataBrowserStatusBar
extends JPanel
implements ChangeListener {
    private static final int FACTOR = 10;
    private DataBrowserUI view;
    private OneKnobSlider zoomSlider;
    private JProgressBar progressBar;
    private JLabel status;

    private void initComponents() {
        IconManager icons = IconManager.getInstance();
        this.zoomSlider = new OneKnobSlider(0, 2, 10, 5);
        this.zoomSlider.setEnabled(true);
        this.zoomSlider.setShowArrows(true);
        this.zoomSlider.setToolTipText("Magnifies all thumbnails.");
        this.zoomSlider.setArrowsImageIcon(icons.getImageIcon(0), icons.getImageIcon(1));
        this.zoomSlider.addChangeListener(this);
        this.progressBar = new JProgressBar();
        this.status = new JLabel();
        this.progressBar.setVisible(false);
    }

    private void buildGUI() {
        this.setLayout(new BoxLayout(this, 0));
        JPanel right = new JPanel();
        right.setLayout(new FlowLayout(2, 0, 0));
        right.add(this.progressBar);
        JPanel left = new JPanel();
        left.setLayout(new FlowLayout(0, 0, 0));
        left.add(this.zoomSlider);
        this.add(left);
        this.add(right);
    }

    DataBrowserStatusBar(DataBrowserUI view) {
        if (view == null) {
            throw new IllegalArgumentException("No view.");
        }
        this.view = view;
        this.initComponents();
        this.buildGUI();
    }

    void setSelectedViewIndex(int index) {
        this.zoomSlider.setEnabled(index == 0);
    }

    void setStatus(String s) {
        this.status.setText(s);
    }

    void setProgress(boolean hide, int perc) {
        this.progressBar.setVisible(!hide);
        if (perc < 0) {
            this.progressBar.setIndeterminate(true);
        } else {
            this.progressBar.setStringPainted(true);
            this.progressBar.setIndeterminate(false);
            this.progressBar.setValue(perc);
        }
    }

    public void stateChanged(ChangeEvent e) {
        Object src = e.getSource();
        if (src == this.zoomSlider) {
            int v = this.zoomSlider.getValue();
            this.view.setMagnificationFactor((double)v / 10.0);
        }
    }
}

