/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.openmicroscopy.shoola.agents.dataBrowser.AnnotatedFilter;
import org.openmicroscopy.shoola.agents.dataBrowser.CommentsFilter;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.DataFilter;
import org.openmicroscopy.shoola.agents.dataBrowser.DataObjectCreator;
import org.openmicroscopy.shoola.agents.dataBrowser.RateFilter;
import org.openmicroscopy.shoola.agents.dataBrowser.ReportLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.TagsFilter;
import org.openmicroscopy.shoola.agents.dataBrowser.TagsLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.ThumbnailLoader;
import org.openmicroscopy.shoola.agents.dataBrowser.ThumbnailsManager;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Browser;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.layout.Layout;
import org.openmicroscopy.shoola.agents.dataBrowser.layout.LayoutFactory;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.agents.dataBrowser.view.ImageTableView;
import org.openmicroscopy.shoola.agents.dataBrowser.visitor.ResetThumbnailVisitor;
import org.openmicroscopy.shoola.agents.util.ViewerSorter;
import org.openmicroscopy.shoola.env.data.util.FilterContext;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.ProjectData;
import pojos.TagAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class DataBrowserModel {
    static final int DATASETS = 0;
    static final int IMAGES = 1;
    static final int PROJECTS = 2;
    static final int SEARCH = 3;
    static final int TAGSETS = 4;
    static final int WELLS = 5;
    static final int TAGS = 4;
    private int state = 1;
    private ThumbnailsManager thumbsManager;
    private ThumbnailsManager fullSizeThumbsManager;
    protected ViewerSorter sorter = new ViewerSorter();
    private DataBrowserLoader loader;
    private Collection existingTags;
    protected boolean thumbnailLoaded;
    protected DataBrowser component;
    protected Browser browser;
    protected ImageTableView tableView;
    protected int numberOfImages;
    protected int imagesLoaded;
    protected Object parent;
    protected Object grandParent;

    DataBrowserModel() {
    }

    Object getParent() {
        return this.parent;
    }

    int getNumberOfImages() {
        return this.numberOfImages;
    }

    ViewerSorter getSorter() {
        return this.sorter;
    }

    void layoutBrowser() {
        this.layoutBrowser(1);
    }

    void layoutBrowser(int type) {
        if (this.browser == null) {
            return;
        }
        if (this.browser.getSelectedLayout() == null) {
            Layout layout = LayoutFactory.createLayout(type, this.sorter, 10);
            this.browser.setSelectedLayout(layout);
        }
        this.browser.accept(this.browser.getSelectedLayout());
    }

    ImageTableView createImageTableView() {
        if (this.tableView != null) {
            return this.tableView;
        }
        this.tableView = new ImageTableView(this, (ImageDisplay)this.browser.getUI());
        return this.tableView;
    }

    int getState() {
        return this.state;
    }

    void loadData(boolean refresh, Collection ids) {
        if (refresh) {
            this.browser.accept(new ResetThumbnailVisitor(ids), 0);
        }
        this.loader = this.createDataLoader(refresh, ids);
        if (this.loader == null) {
            this.state = 3;
            return;
        }
        this.state = 2;
        this.loader.load();
    }

    void setGrandParent(Object grandParent) {
        this.grandParent = grandParent;
    }

    Browser getBrowser() {
        return this.browser;
    }

    ImageTableView getTableView() {
        return this.tableView;
    }

    void initialize(DataBrowser component) {
        this.component = component;
    }

    void setThumbnail(long imageID, BufferedImage thumb, int maxEntries) {
        if (this.thumbsManager == null) {
            this.thumbsManager = this.getType() == 5 ? new ThumbnailsManager(this.getNodes(), maxEntries) : new ThumbnailsManager(this.browser.getVisibleImageNodes(), maxEntries);
        }
        this.thumbsManager.setThumbnail(imageID, thumb);
        if (this.thumbsManager.isDone()) {
            this.state = 3;
            this.thumbsManager = null;
        }
    }

    boolean setSlideViewImage(long imageID, BufferedImage thumb) {
        if (this.fullSizeThumbsManager != null) {
            this.fullSizeThumbsManager.setFullSizeImage(imageID, thumb);
            if (this.fullSizeThumbsManager.isDone()) {
                this.state = 3;
                this.fullSizeThumbsManager = null;
                return true;
            }
        }
        return false;
    }

    void discard() {
    }

    void cancelFiltering() {
    }

    void cancelSlideShow() {
    }

    void setState(int state) {
        this.state = state;
    }

    void fireFilteringByRate(int rate, Set nodes) {
        this.state = 4;
        RateFilter loader = new RateFilter(this.component, rate, nodes);
        loader.load();
    }

    void fireFilteringByTags(List<String> tags, Set<DataObject> nodes) {
        this.state = 4;
        TagsFilter loader = new TagsFilter(this.component, tags, nodes);
        loader.load();
    }

    void fireFilteringByComments(List<String> comments, Set<DataObject> nodes) {
        this.state = 4;
        CommentsFilter loader = new CommentsFilter(this.component, comments, nodes);
        loader.load();
    }

    void fireFilteringByContext(FilterContext context, Set<DataObject> nodes) {
        this.state = 4;
        DataFilter loader = new DataFilter(this.component, context, nodes);
        loader.load();
    }

    void fireFilteringByAnnotated(Class annotationType, boolean annotated, Set<DataObject> nodes) {
        this.state = 4;
        AnnotatedFilter loader = new AnnotatedFilter(this.component, annotationType, annotated, nodes);
        loader.load();
    }

    void fireTagsLoading() {
        this.state = 2;
        TagsLoader loader = new TagsLoader(this.component);
        loader.load();
    }

    void fireFullSizeLoading(Collection<ImageNode> images) {
        HashSet<ImageData> nodes = new HashSet<ImageData>();
        HashSet<ImageNode> toKeep = new HashSet<ImageNode>();
        for (ImageNode node : images) {
            if (node.getThumbnail().getFullSizeImage() != null) continue;
            nodes.add((ImageData)node.getHierarchyObject());
            toKeep.add(node);
        }
        if (nodes.size() > 0) {
            this.fullSizeThumbsManager = new ThumbnailsManager(toKeep, toKeep.size());
            ThumbnailLoader loader = new ThumbnailLoader(this.component, nodes, false);
            loader.load();
            this.state = 6;
        }
    }

    void fireDataSaving(DataObject data, Collection images) {
        TagAnnotationData tag;
        DataObject p = null;
        if (this.parent instanceof DataObject) {
            p = (DataObject)this.parent;
        }
        if (this.grandParent != null && this.grandParent instanceof DataObject) {
            p = (DataObject)this.grandParent;
        }
        if (data instanceof DatasetData) {
            if (!(p instanceof ProjectData)) {
                p = null;
            }
        } else if (data instanceof TagAnnotationData && p instanceof TagAnnotationData && !"openmicroscopy.org/omero/insight/tagset".equals((tag = (TagAnnotationData)p).getNameSpace())) {
            p = null;
        }
        DataObjectCreator loader = new DataObjectCreator(this.component, p, data, images);
        loader.load();
    }

    void fireReportLoading(Collection images, List<Class> types, String name) {
        ReportLoader loader = new ReportLoader(this.component, types, this.sorter.sort(images), name);
        loader.load();
    }

    void setTags(Collection tags) {
        this.existingTags = tags;
    }

    boolean isImagesModel() {
        switch (this.getType()) {
            case 0: 
            case 1: 
            case 4: {
                return true;
            }
        }
        return false;
    }

    Collection getExistingTags() {
        return this.existingTags;
    }

    boolean isRollOver() {
        return this.browser.isRollOver();
    }

    List sortCollection(Collection collection) {
        return this.sorter.sort(collection);
    }

    protected abstract DataBrowserLoader createDataLoader(boolean var1, Collection var2);

    protected abstract int getType();

    protected abstract List<ImageDisplay> getNodes();
}

