/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserComponent;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DatasetsModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.ImagesModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.SearchModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.TagSetsModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.TagsModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.WellsModel;
import pojos.DataObject;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.ProjectData;
import pojos.TagAnnotationData;
import pojos.WellData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataBrowserFactory
implements ChangeListener {
    private static final DataBrowserFactory singleton = new DataBrowserFactory();
    private Set<String> discardedBrowsers;
    private Map<String, DataBrowser> browsers = new HashMap<String, DataBrowser>();
    private DataBrowser searchBrowser = null;
    private boolean rndSettingsToCopy = false;
    private Class dataToCopy = null;

    public static final void discardAll() {
        Iterator<String> i = DataBrowserFactory.singleton.browsers.keySet().iterator();
        while (i.hasNext()) {
            DataBrowserFactory.singleton.discardedBrowsers.add(i.next());
        }
        DataBrowserFactory.singleton.browsers.clear();
    }

    public static final DataBrowser getSearchBrowser(Collection<DataObject> result) {
        return singleton.createSearchDataBrowser(result);
    }

    public static final DataBrowser getSearchBrowser() {
        return DataBrowserFactory.singleton.searchBrowser;
    }

    public static final DataBrowser getWellsDataBrowser(Object grandParent, Object parent, Set<WellData> wells) {
        return singleton.createWellsDataBrowser(grandParent, parent, wells);
    }

    public static final DataBrowser getDataBrowser(Object grandParent, Object parent, Set<ImageData> images) {
        return singleton.createImagesDataBrowser(grandParent, parent, images);
    }

    public static final DataBrowser getTagsBrowser(TagAnnotationData parent, Set<DataObject> nodes, boolean withImages) {
        return singleton.createTagsDataBrowser((DataObject)parent, nodes, withImages);
    }

    public static final DataBrowser getDataBrowser(ProjectData parent, Set<DatasetData> nodes) {
        return singleton.createDatasetsDataBrowser((DataObject)parent, nodes);
    }

    public static final DataBrowser getDataBrowser(Object parent) {
        if (parent == null) {
            return null;
        }
        String key = parent.toString();
        if (parent instanceof DataObject) {
            key = key + ((DataObject)parent).getId();
        }
        return DataBrowserFactory.singleton.browsers.get(key);
    }

    public static final boolean hasBeenDiscarded(Object parent) {
        if (parent == null) {
            return false;
        }
        String key = parent.toString();
        if (parent instanceof DataObject) {
            key = key + ((DataObject)parent).getId();
        }
        for (String value : DataBrowserFactory.singleton.discardedBrowsers) {
            if (!value.equals(key)) continue;
            return true;
        }
        return false;
    }

    public static final void refreshThumbnails(Collection ids) {
        if (ids != null && ids.size() > 0) {
            if (DataBrowserFactory.singleton.searchBrowser != null) {
                DataBrowserFactory.singleton.searchBrowser.reloadThumbnails(ids);
            }
            Iterator<String> i = DataBrowserFactory.singleton.browsers.keySet().iterator();
            while (i.hasNext()) {
                DataBrowserFactory.singleton.browsers.get(i.next()).reloadThumbnails(ids);
            }
        }
    }

    public static final void setRndSettingsToCopy(boolean rndSettingsToCopy) {
        DataBrowserFactory.singleton.rndSettingsToCopy = rndSettingsToCopy;
        Iterator<String> v = DataBrowserFactory.singleton.browsers.keySet().iterator();
        while (v.hasNext()) {
            DataBrowserComponent comp = (DataBrowserComponent)DataBrowserFactory.singleton.browsers.get(v.next());
            comp.notifyRndSettingsToCopy();
        }
        if (DataBrowserFactory.singleton.searchBrowser != null) {
            ((DataBrowserComponent)DataBrowserFactory.singleton.searchBrowser).notifyRndSettingsToCopy();
        }
    }

    public static final void setDataToCopy(Class dataToCopy) {
        DataBrowserFactory.singleton.dataToCopy = dataToCopy;
        Iterator<String> v = DataBrowserFactory.singleton.browsers.keySet().iterator();
        while (v.hasNext()) {
            DataBrowserComponent comp = (DataBrowserComponent)DataBrowserFactory.singleton.browsers.get(v.next());
            comp.notifyDataToCopy();
        }
        if (DataBrowserFactory.singleton.searchBrowser != null) {
            ((DataBrowserComponent)DataBrowserFactory.singleton.searchBrowser).notifyDataToCopy();
        }
    }

    static boolean hasRndSettingsToCopy() {
        return DataBrowserFactory.singleton.rndSettingsToCopy;
    }

    static Class hasDataToCopy() {
        return DataBrowserFactory.singleton.dataToCopy;
    }

    private DataBrowserFactory() {
        this.discardedBrowsers = new HashSet<String>();
    }

    private DataBrowser createWellsDataBrowser(Object grandParent, Object parent, Set<WellData> wells) {
        WellsModel model = new WellsModel(parent, wells);
        model.setGrandParent(grandParent);
        DataBrowserComponent comp = new DataBrowserComponent(model);
        model.initialize(comp);
        comp.initialize();
        String key = parent.toString();
        if (parent instanceof DataObject) {
            key = key + ((DataObject)parent).getId();
        }
        this.browsers.put(key, comp);
        return comp;
    }

    private DataBrowser createImagesDataBrowser(Object grandParent, Object parent, Set<ImageData> images) {
        ImagesModel model = new ImagesModel(parent, images);
        model.setGrandParent(grandParent);
        DataBrowserComponent comp = new DataBrowserComponent(model);
        model.initialize(comp);
        comp.initialize();
        String key = parent.toString();
        if (parent instanceof DataObject) {
            key = key + ((DataObject)parent).getId();
        }
        this.browsers.put(key, comp);
        return comp;
    }

    private DataBrowser createDatasetsDataBrowser(DataObject parent, Set<DatasetData> datasets) {
        DatasetsModel model = new DatasetsModel(parent, datasets);
        DataBrowserComponent comp = new DataBrowserComponent(model);
        model.initialize(comp);
        comp.initialize();
        String key = parent.toString() + parent.getId();
        this.browsers.put(key, comp);
        return comp;
    }

    private DataBrowser createTagsDataBrowser(DataObject parent, Set<DataObject> dataObjects, boolean withImages) {
        TagsModel model = new TagsModel(parent, dataObjects, withImages);
        DataBrowserComponent comp = new DataBrowserComponent(model);
        model.initialize(comp);
        comp.initialize();
        String key = parent.toString() + parent.getId();
        this.browsers.put(key, comp);
        return comp;
    }

    private DataBrowser createTagSetsDataBrowser(DataObject parent, Set<TagAnnotationData> tags) {
        TagSetsModel model = new TagSetsModel(parent, tags);
        DataBrowserComponent comp = new DataBrowserComponent(model);
        model.initialize(comp);
        comp.initialize();
        String key = parent.toString() + parent.getId();
        this.browsers.put(key, comp);
        return comp;
    }

    private DataBrowser createSearchDataBrowser(Collection<DataObject> result) {
        SearchModel model = new SearchModel(result);
        DataBrowserComponent comp = new DataBrowserComponent(model);
        model.initialize(comp);
        comp.initialize();
        this.searchBrowser = comp;
        return comp;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
    }
}

