/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.view;

import java.awt.Cursor;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.JComponent;
import org.openmicroscopy.shoola.agents.dataBrowser.DataBrowserAgent;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.Browser;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageDisplay;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageFinder;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowser;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserControl;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserFactory;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserModel;
import org.openmicroscopy.shoola.agents.dataBrowser.view.DataBrowserUI;
import org.openmicroscopy.shoola.agents.dataBrowser.view.ImageTableView;
import org.openmicroscopy.shoola.agents.dataBrowser.view.WellsModel;
import org.openmicroscopy.shoola.agents.dataBrowser.visitor.NodesFinder;
import org.openmicroscopy.shoola.agents.dataBrowser.visitor.RegexFinder;
import org.openmicroscopy.shoola.agents.dataBrowser.visitor.ResetNodesVisitor;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import org.openmicroscopy.shoola.env.data.util.FilterContext;
import org.openmicroscopy.shoola.env.data.util.StructuredDataResults;
import org.openmicroscopy.shoola.env.log.LogMessage;
import org.openmicroscopy.shoola.env.log.Logger;
import org.openmicroscopy.shoola.env.ui.UserNotifier;
import org.openmicroscopy.shoola.util.file.ExcelWriter;
import org.openmicroscopy.shoola.util.ui.RegExFactory;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.component.AbstractComponent;
import pojos.DataObject;
import pojos.ImageData;
import pojos.TagAnnotationData;
import pojos.TextualAnnotationData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DataBrowserComponent
extends AbstractComponent
implements DataBrowser {
    private DataBrowserModel model;
    private DataBrowserControl controller;
    private DataBrowserUI view;

    DataBrowserComponent(DataBrowserModel model) {
        if (model == null) {
            throw new NullPointerException("No model.");
        }
        this.model = model;
    }

    void initialize() {
        this.controller = new DataBrowserControl();
        this.view = new DataBrowserUI();
        this.controller.initialize(this, this.view);
        this.view.initialize(this.model, this.controller);
    }

    void notifyRndSettingsToCopy() {
        if (this.model.getState() == 5) {
            return;
        }
        this.firePropertyChange("rndSettingToCopy", Boolean.FALSE, Boolean.TRUE);
    }

    void notifyDataToCopy() {
        if (this.model.getState() == 5) {
            return;
        }
        this.firePropertyChange("itemsToCopy", Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public void activate() {
        Integer max = (Integer)DataBrowserAgent.getRegistry().lookup("/views/MAX_ENTRIES");
        if (this.model.getNumberOfImages() < max) {
            this.model.loadData(false, null);
        } else {
            this.view.setSelectedView(1);
        }
        if (this.model.getBrowser() != null) {
            Browser browser = this.model.getBrowser();
            ResetNodesVisitor visitor = new ResetNodesVisitor(null, false);
            browser.accept(visitor, 1);
            browser.addPropertyChangeListener(this.controller);
        }
        this.fireStateChange();
    }

    @Override
    public void discard() {
        this.model.discard();
    }

    @Override
    public int getHierarchyType() {
        return 0;
    }

    @Override
    public int getState() {
        return this.model.getState();
    }

    @Override
    public void setStatus(String description, int perc) {
        int state = this.model.getState();
        this.view.setStatus(description, state != 2, perc);
    }

    @Override
    public void setThumbnail(long imageID, BufferedImage thumb, int maxEntries) {
        int previousState = this.model.getState();
        this.model.setThumbnail(imageID, thumb, maxEntries);
        if (previousState != this.model.getState()) {
            this.fireStateChange();
        }
    }

    @Override
    public void setSelectedDisplay(ImageDisplay node) {
        if (node == null) {
            return;
        }
        Object object = node.getHierarchyObject();
        ArrayList<Object> objects = new ArrayList<Object>();
        ArrayList<Object> others = new ArrayList<Object>();
        Collection selected = this.model.getBrowser().getSelectedDisplays();
        for (ImageDisplay n : selected) {
            if (n == node) continue;
            others.add(n.getHierarchyObject());
        }
        objects.add(others);
        if (node.equals(this.model.getBrowser().getUI())) {
            objects.add(this.model.parent);
        } else {
            objects.add(object);
        }
        if (object instanceof DataObject) {
            ImageDisplay p = node.getParentDisplay();
            Object parent = p.getHierarchyObject();
            if (!(parent instanceof DataObject)) {
                parent = this.model.getParent();
            }
            objects.add(parent);
        }
        this.firePropertyChange("selectedNodeDisplay", null, objects);
    }

    @Override
    public void setSelectedNodes(List<DataObject> objects) {
        ImageTableView tbView = this.model.getTableView();
        if (tbView != null) {
            tbView.setSelectedNodes(objects);
        }
        this.model.getBrowser().setSelectedNodes(objects);
    }

    @Override
    public void markUnmodifiedNodes(Class type, Collection<Long> ids) {
        ImageTableView tbView = this.model.getTableView();
        if (tbView != null && ids != null) {
            tbView.markUnmodifiedNodes(type, ids);
        }
        this.model.getBrowser().markUnmodifiedNodes(type, ids);
    }

    @Override
    public JComponent getUI() {
        return this.view;
    }

    @Override
    public void filterByRate(int rate) {
        if (this.model.getState() == 4) {
            UserNotifier un = DataBrowserAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Filtering", "Currenlty filering data. Please wait.");
            return;
        }
        Browser browser = this.model.getBrowser();
        ImageFinder finder = new ImageFinder();
        browser.accept(finder, 0);
        Set<ImageData> nodes = finder.getImages();
        if (nodes != null && nodes.size() > 0) {
            this.view.setCursor(Cursor.getPredefinedCursor(3));
            this.model.fireFilteringByRate(rate, nodes);
            this.fireStateChange();
        }
    }

    @Override
    public void showAll() {
        this.model.cancelFiltering();
        this.model.getBrowser().showAll();
        this.view.layoutUI();
        this.view.setNumberOfImages(this.model.getNumberOfImages());
    }

    @Override
    public void filterByComments(List<String> comments) {
        if (this.model.getState() == 4) {
            UserNotifier un = DataBrowserAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Filtering", "Currenlty filering data. Please wait.");
            return;
        }
        Browser browser = this.model.getBrowser();
        Set<DataObject> nodes = browser.getOriginal();
        if (nodes != null && nodes.size() > 0) {
            this.view.setCursor(Cursor.getPredefinedCursor(3));
            this.model.fireFilteringByComments(comments, nodes);
            this.fireStateChange();
        }
    }

    @Override
    public void filterByFullText(List<String> terms) {
        Pattern pattern;
        if (terms == null || terms.size() == 0) {
            return;
        }
        Browser browser = this.model.getBrowser();
        try {
            pattern = RegExFactory.createPattern(RegExFactory.formatSearchTextAsString(terms));
        }
        catch (PatternSyntaxException pse) {
            UserNotifier un = DataBrowserAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Find", "Some characters are not recognised.");
            return;
        }
        this.view.setCursor(Cursor.getPredefinedCursor(3));
        RegexFinder finder = new RegexFinder(pattern);
        browser.accept(finder);
        List<ImageDisplay> nodes = finder.getFoundNodes();
        browser.setFilterNodes(nodes);
        this.view.layoutUI();
        this.view.setNumberOfImages(nodes.size());
        this.view.setCursor(Cursor.getPredefinedCursor(0));
    }

    @Override
    public void filterByTags(List<String> tags) {
        if (this.model.getState() == 4) {
            UserNotifier un = DataBrowserAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Filtering", "Currenlty filering data. Please wait.");
            return;
        }
        Browser browser = this.model.getBrowser();
        Set<DataObject> nodes = browser.getOriginal();
        if (nodes != null && nodes.size() > 0) {
            this.view.setCursor(Cursor.getPredefinedCursor(3));
            this.model.fireFilteringByTags(tags, nodes);
            this.fireStateChange();
        }
    }

    @Override
    public void setFilteredNodes(List<DataObject> objects) {
        List<ImageDisplay> nodes;
        if (objects == null) {
            return;
        }
        Browser browser = this.model.getBrowser();
        if (objects.size() > 0) {
            NodesFinder finder = new NodesFinder(objects);
            browser.accept(finder);
            nodes = finder.getFoundNodes();
        } else {
            nodes = new ArrayList<ImageDisplay>();
        }
        browser.setFilterNodes(nodes);
        this.view.layoutUI();
        this.view.setNumberOfImages(nodes.size());
        this.model.setState(3);
        this.view.setCursor(Cursor.getPredefinedCursor(0));
        this.fireStateChange();
    }

    @Override
    public void filterByContext(FilterContext context) {
        if (context == null) {
            UserNotifier un = DataBrowserAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Filtering", "No filtering context.");
            return;
        }
        if (this.model.getState() == 4) {
            UserNotifier un = DataBrowserAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Filtering", "Currenlty filering data. Please wait.");
            return;
        }
        Browser browser = this.model.getBrowser();
        Set<DataObject> nodes = browser.getOriginal();
        if (nodes != null && nodes.size() > 0) {
            this.view.setCursor(Cursor.getPredefinedCursor(3));
            this.view.filterByContext(context);
            this.model.fireFilteringByContext(context, nodes);
            this.fireStateChange();
        }
    }

    @Override
    public void loadExistingTags() {
        this.model.fireTagsLoading();
    }

    @Override
    public void setExistingTags(Collection tags) {
        this.model.setTags(tags);
        this.view.setTags(tags);
    }

    @Override
    public void setSlideViewImage(long imageID, BufferedImage thumb) {
        boolean done = this.model.setSlideViewImage(imageID, thumb);
        if (done) {
            this.view.setSlideViewStatus(true, -1);
        }
    }

    @Override
    public void setSlideViewStatus(String description, int perc) {
        int state = this.model.getState();
        if (state == 6) {
            this.view.setSlideViewStatus(false, perc);
        }
    }

    @Override
    public void createDataObject(DataObject data) {
        Set<ImageData> images;
        if (data == null) {
            return;
        }
        Browser browser = this.model.getBrowser();
        Collection set = browser.getSelectedDisplays();
        if (set != null && set.size() > 0) {
            images = new HashSet<ImageData>();
            for (ImageDisplay display : set) {
                Object ho = display.getHierarchyObject();
                if (!(ho instanceof DataObject)) continue;
                images.add((ImageData)ho);
            }
        } else {
            images = browser.getVisibleImages();
        }
        this.model.fireDataSaving(data, images);
    }

    @Override
    public void setDataObjectCreated(DataObject object, DataObject parent) {
        HashMap<DataObject, DataObject> m = new HashMap<DataObject, DataObject>(1);
        m.put(object, parent);
        this.firePropertyChange("dataObjectCreated", null, m);
    }

    @Override
    public void setTableNodesSelected(List<ImageDisplay> nodes) {
        this.model.getBrowser().setNodesSelection(nodes);
    }

    @Override
    public void setUnselectedDisplay(ImageDisplay node) {
        if (node == null) {
            return;
        }
        Object object = node.getHierarchyObject();
        ArrayList<Object> objects = new ArrayList<Object>();
        objects.add(this.model.getBrowser().isMultiSelection());
        objects.add(object);
        if (object instanceof DataObject) {
            ImageDisplay p = node.getParentDisplay();
            Object parent = p.getHierarchyObject();
            if (!(parent instanceof DataObject)) {
                parent = this.model.getParent();
            }
            objects.add(parent);
        }
        this.firePropertyChange("unselectedNodeDisplay", null, objects);
    }

    @Override
    public Browser getBrowser() {
        if (this.model.getState() == 5) {
            throw new IllegalArgumentException("This method cannot be invoked in the DISCARDED state.");
        }
        return this.model.getBrowser();
    }

    @Override
    public void pasteRndSettings() {
        if (this.model.getState() == 5) {
            throw new IllegalArgumentException("This method cannot be invoked in the DISCARDED state.");
        }
        if (this.model.getType() == 3) {
            this.firePropertyChange("pasteRndSettings", null, this.getBrowser().getSelectedDataObjects());
        } else {
            this.firePropertyChange("pasteRndSettings", Boolean.FALSE, Boolean.TRUE);
        }
    }

    @Override
    public void resetRndSettings() {
        if (this.model.getState() == 5) {
            throw new IllegalArgumentException("This method cannot be invoked in the DISCARDED state.");
        }
        if (this.model.getType() == 3) {
            this.firePropertyChange("resetRndSettings", null, this.getBrowser().getSelectedDataObjects());
        } else {
            this.firePropertyChange("resetRndSettings", Boolean.FALSE, Boolean.TRUE);
        }
    }

    @Override
    public void copyRndSettings() {
        if (this.model.getState() == 5) {
            throw new IllegalArgumentException("This method cannot be invoked in the DISCARDED state.");
        }
        if (this.model.getType() == 3) {
            ImageDisplay display = this.getBrowser().getLastSelectedDisplay();
            Object o = display.getHierarchyObject();
            if (!(o instanceof ImageData)) {
                return;
            }
            ImageData img = (ImageData)o;
            this.firePropertyChange("copyRndSettings", null, img);
        } else {
            this.firePropertyChange("copyRndSettings", Boolean.FALSE, null);
        }
    }

    @Override
    public void copy() {
        if (this.model.getState() == 5) {
            throw new IllegalArgumentException("This method cannot be invoked in the DISCARDED state.");
        }
        this.firePropertyChange("copyItems", Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public void cut() {
        if (this.model.getState() == 5) {
            throw new IllegalArgumentException("This method cannot be invoked in the DISCARDED state.");
        }
        this.firePropertyChange("cutItems", Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public void paste() {
        if (this.model.getState() == 5) {
            throw new IllegalArgumentException("This method cannot be invoked in the DISCARDED state.");
        }
        this.firePropertyChange("pasteItems", Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public void remove() {
        if (this.model.getState() == 5) {
            throw new IllegalArgumentException("This method cannot be invoked in the DISCARDED state.");
        }
        this.firePropertyChange("removeItems", Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public boolean isObjectWritable(Object ho) {
        if (this.model.getState() == 5) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        long id = DataBrowserAgent.getUserDetails().getId();
        long groupId = -1L;
        return EditorUtil.isWritable(ho, id, groupId);
    }

    @Override
    public boolean isReadable(DataObject ho) {
        if (this.model.getState() == 5) {
            throw new IllegalStateException("This method cannot be invoked in the DISCARDED state.");
        }
        long id = DataBrowserAgent.getUserDetails().getId();
        long groupId = -1L;
        return EditorUtil.isReadable(ho, id, groupId);
    }

    @Override
    public void reloadThumbnails(Collection ids) {
        switch (this.model.getState()) {
            case 5: {
                throw new IllegalStateException("This method cannot beinvoked in the DISCARDED state.");
            }
            case 1: {
                return;
            }
        }
        this.model.loadData(true, ids);
        this.fireStateChange();
    }

    @Override
    public void setOriginalSettings() {
        if (this.model.getState() == 5) {
            throw new IllegalArgumentException("This method cannot be invoked in the DISCARDED state.");
        }
        if (this.model.getType() == 3) {
            this.firePropertyChange("setOriginalRndSettings", null, this.getBrowser().getSelectedDataObjects());
        } else {
            this.firePropertyChange("setOriginalRndSettings", Boolean.FALSE, Boolean.TRUE);
        }
    }

    @Override
    public void filterByTagged(boolean tagged) {
        if (this.model.getState() == 4) {
            UserNotifier un = DataBrowserAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Filtering", "Currenlty filering data. Please wait.");
            return;
        }
        Browser browser = this.model.getBrowser();
        Set<DataObject> nodes = browser.getOriginal();
        if (nodes != null && nodes.size() > 0) {
            this.view.setCursor(Cursor.getPredefinedCursor(3));
            this.model.fireFilteringByAnnotated(TagAnnotationData.class, tagged, nodes);
            this.fireStateChange();
        }
    }

    @Override
    public void filterByCommented(boolean commented) {
        if (this.model.getState() == 4) {
            UserNotifier un = DataBrowserAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Filtering", "Currenlty filering data. Please wait.");
            return;
        }
        Browser browser = this.model.getBrowser();
        Set<DataObject> nodes = browser.getOriginal();
        if (nodes != null && nodes.size() > 0) {
            this.view.setCursor(Cursor.getPredefinedCursor(3));
            this.model.fireFilteringByAnnotated(TextualAnnotationData.class, commented, nodes);
            this.fireStateChange();
        }
    }

    @Override
    public void setComponentTitle(String title) {
        Browser browser = this.model.getBrowser();
        if (browser != null) {
            browser.setComponentTitle(title);
        }
    }

    @Override
    public void viewField(int selectedIndex) {
        if (!(this.model instanceof WellsModel)) {
            return;
        }
        ((WellsModel)this.model).viewField(selectedIndex);
        this.view.repaint();
        this.model.loadData(false, null);
    }

    @Override
    public void saveThumbnails(String name) {
        if (!this.isImagesModel()) {
            return;
        }
        Browser browser = this.model.getBrowser();
        List<ImageNode> l = browser.getVisibleImageNodes();
        UserNotifier un = DataBrowserAgent.getRegistry().getUserNotifier();
        if (l == null || l.size() == 0) {
            un.notifyInfo("Save Thumbnails", "No images to save");
            return;
        }
        List nodes = this.model.sortCollection(l);
        Iterator i = nodes.iterator();
        try {
            String imageName;
            ImageNode node;
            ExcelWriter writer = new ExcelWriter(name);
            writer.openFile();
            writer.createSheet("Thumbnails");
            int n = browser.getSelectedLayout().getImagesPerRow();
            int row = 0;
            int col = 0;
            int w = 96;
            int h = 96;
            int count = 0;
            while (i.hasNext()) {
                node = (ImageNode)i.next();
                imageName = node.toString();
                BufferedImage thumbnail = node.getThumbnail().getFullScaleThumb();
                writer.addImageToWorkbook(imageName, thumbnail);
                writer.writeImage(row, col, w, h, imageName);
                writer.writeElement(row + 6, col, imageName);
                if (count < n) {
                    col += 4;
                } else {
                    col = 0;
                    count = -1;
                    row += 7;
                }
                ++count;
            }
            writer.createSheet("Legend");
            i = nodes.iterator();
            row = 0;
            col = 0;
            writer.setCellStyle(row, col, row, col + 1, "bold_default");
            writer.writeElement(row, col, "id");
            writer.writeElement(row, col + 1, "name");
            ++row;
            while (i.hasNext()) {
                node = (ImageNode)i.next();
                imageName = node.toString();
                writer.writeElement(row, col, ((DataObject)node.getHierarchyObject()).getId());
                writer.writeElement(row, col + 1, imageName);
                ++row;
            }
            writer.close();
        }
        catch (Exception e) {
            Logger logger = DataBrowserAgent.getRegistry().getLogger();
            LogMessage msg = new LogMessage();
            msg.print("Error while saving.");
            msg.print(e);
            logger.error((Object)this, msg);
            un.notifyInfo("Report", "An error occurs while saving the file.");
        }
    }

    @Override
    public boolean isImagesModel() {
        if (this.model.getState() == 5) {
            return false;
        }
        return this.model.isImagesModel();
    }

    @Override
    public void setReportData(Map<ImageNode, StructuredDataResults> data, List<Class> types, String name) {
        if (data == null || data.size() == 0) {
            return;
        }
        UserNotifier un = DataBrowserAgent.getRegistry().getUserNotifier();
        List sorted = this.model.sortCollection(data.keySet());
        Iterator<Object> i = sorted.iterator();
        HashMap<Long, ArrayList<Object>> tagImageMap = new HashMap<Long, ArrayList<Object>>();
        HashMap<Long, TagAnnotationData> tagMap = new HashMap<Long, TagAnnotationData>();
        HashMap<Object, Integer> rowImage = new HashMap<Object, Integer>();
        try {
            int count;
            ArrayList<Object> nodes;
            long id;
            String imageName;
            ImageNode node;
            ExcelWriter writer = new ExcelWriter(name);
            writer.openFile();
            writer.createSheet("Tags");
            int col = 0;
            int row = 0;
            writer.setCellStyle(row, col, row, col + 1, "bold_default");
            writer.writeElement(row, col, "id");
            writer.writeElement(row, col + 1, "name");
            ++row;
            while (i.hasNext()) {
                node = (ImageNode)i.next();
                imageName = node.toString();
                rowImage.put(node.getHierarchyObject(), row);
                writer.writeElement(row, col, ((DataObject)node.getHierarchyObject()).getId());
                writer.writeElement(row, col + 1, imageName);
                ++row;
                StructuredDataResults r = data.get(node);
                Collection l = r.getTags();
                if (l == null) continue;
                for (TagAnnotationData tag : l) {
                    id = tag.getId();
                    nodes = (List)tagImageMap.get(id);
                    if (!tagMap.containsKey(id)) {
                        tagMap.put(id, tag);
                    }
                    if (nodes == null) {
                        nodes = new ArrayList<Object>();
                        tagImageMap.put(id, nodes);
                    }
                    nodes.add(node.getHierarchyObject());
                }
            }
            col = 2;
            row = 0;
            List sortedTags = this.model.sortCollection(tagMap.keySet());
            Iterator k = sortedTags.iterator();
            int numberOfImages = data.size();
            while (k.hasNext()) {
                TagAnnotationData tag;
                row = 0;
                count = 0;
                id = (Long)k.next();
                tag = (TagAnnotationData)tagMap.get(id);
                writer.setCellStyle(row, col, "bold_default");
                writer.writeElement(row, col, tag.getTagValue());
                nodes = (ArrayList<Object>)tagImageMap.get(id);
                i = data.keySet().iterator();
                while (i.hasNext()) {
                    ++count;
                    node = (ImageNode)i.next();
                    Object object = node.getHierarchyObject();
                    row = (Integer)rowImage.get(object);
                    int value = 0;
                    if (nodes.contains(object)) {
                        value = 1;
                    }
                    writer.setCellStyle(row, col, "integer");
                    writer.writeElement(row, col, value);
                }
                writer.setCellStyle(count + 1, col, "cellborder_topline");
                writer.setCellStyle(row, col, "integer");
                writer.writeElement(count + 1, col, nodes.size());
                writer.setCellStyle(count + 2, col, "2 decimal points");
                double v = (double)nodes.size() / (double)numberOfImages;
                writer.writeElement(count + 2, col, UIUtilities.formatToDecimal(v * 100.0) + "%");
                ++col;
            }
            writer.sizeAllColumnsToFit();
            writer.createSheet("Thumbnails");
            i = sorted.iterator();
            int n = this.model.getBrowser().getSelectedLayout().getImagesPerRow();
            row = 0;
            col = 0;
            int w = 48;
            int h = 48;
            count = 0;
            while (i.hasNext()) {
                node = (ImageNode)i.next();
                id = ((DataObject)node.getHierarchyObject()).getId();
                imageName = node.toString();
                BufferedImage thumbnail = node.getThumbnail().getFullScaleThumb();
                writer.addImageToWorkbook(imageName, thumbnail);
                writer.writeImage(row, col, w, h, imageName);
                writer.writeElement(row + 3, col, id);
                if (count < n) {
                    ++col;
                } else {
                    col = 0;
                    row += 4;
                }
                ++count;
            }
            writer.close();
            un.notifyInfo("Report", "The report has been successfully created.");
        }
        catch (Exception e) {
            Logger logger = DataBrowserAgent.getRegistry().getLogger();
            LogMessage msg = new LogMessage();
            msg.print("Error while writing report.");
            msg.print(e);
            logger.error((Object)this, msg);
            un.notifyInfo("Report", "An error occurs while creating the report.");
        }
    }

    @Override
    public void createReport(String name) {
        Browser browser = this.model.getBrowser();
        List<ImageNode> nodes = browser.getVisibleImageNodes();
        if (nodes == null || nodes.size() == 0) {
            UserNotifier un = DataBrowserAgent.getRegistry().getUserNotifier();
            un.notifyInfo("Create Report", "No images displayed");
            return;
        }
        ArrayList<Class> types = new ArrayList<Class>();
        this.model.fireReportLoading(nodes, types, name);
    }

    @Override
    public boolean hasRndSettings() {
        return DataBrowserFactory.hasRndSettingsToCopy();
    }

    @Override
    public Class hasDataToCopy() {
        return DataBrowserFactory.hasDataToCopy();
    }

    @Override
    public void showTagWizard() {
        this.firePropertyChange("tagWizard", Boolean.FALSE, Boolean.TRUE);
    }

    @Override
    public void createNewExperiment() {
        this.firePropertyChange("createNewExperiment", Boolean.FALSE, Boolean.TRUE);
    }
}

