/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.util;

import java.awt.Component;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.openmicroscopy.shoola.agents.dataBrowser.IconManager;
import org.openmicroscopy.shoola.agents.dataBrowser.view.ImageTableNode;
import org.openmicroscopy.shoola.agents.util.EditorUtil;
import pojos.DatasetData;
import pojos.ImageData;
import pojos.ProjectData;

public class ImageTableRenderer
extends DefaultTreeCellRenderer {
    private IconManager icons;

    public ImageTableRenderer() {
        this.setOpaque(true);
        this.icons = IconManager.getInstance();
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        if (selected) {
            if (value instanceof ImageTableNode) {
                this.setBackground(((ImageTableNode)((Object)value)).getHighLight());
            } else {
                this.setBackground(this.getBackgroundSelectionColor());
            }
        } else {
            this.setBackground(this.getBackgroundNonSelectionColor());
        }
        if (!(value instanceof ImageTableNode)) {
            return this;
        }
        ImageTableNode node = (ImageTableNode)((Object)value);
        Object v = node.getHierarchyObject();
        if (v instanceof ImageData) {
            if (EditorUtil.isAnnotated(v)) {
                this.setIcon(this.icons.getIcon(35));
            } else {
                this.setIcon(this.icons.getIcon(14));
            }
            this.setText(node.getUserObject().toString());
        } else if (v instanceof DatasetData) {
            this.setIcon(this.icons.getIcon(15));
            this.setText(node.getUserObject().toString());
        } else if (v instanceof ProjectData) {
            this.setIcon(this.icons.getIcon(16));
            this.setText(node.getUserObject().toString());
        }
        return this;
    }
}

