/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.util;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import layout.TableLayout;
import org.jdesktop.swingx.JXDatePicker;
import org.openmicroscopy.shoola.agents.metadata.MetadataViewerAgent;
import org.openmicroscopy.shoola.agents.util.tagging.util.TagCellRenderer;
import org.openmicroscopy.shoola.agents.util.tagging.util.TagItem;
import org.openmicroscopy.shoola.env.data.util.FilterContext;
import org.openmicroscopy.shoola.util.ui.HistoryDialog;
import org.openmicroscopy.shoola.util.ui.RatingComponent;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import org.openmicroscopy.shoola.util.ui.search.SearchUtil;
import pojos.DataObject;
import pojos.TagAnnotationData;
import pojos.TextualAnnotationData;

public class FilteringDialog
extends JDialog
implements ActionListener,
DocumentListener,
PropertyChangeListener {
    public static final String LOAD_TAG_PROPERTY = "loadTag";
    public static final String FILTER_PROPERTY = "filter";
    private static final String TITLE = "Filtering images in Workspace";
    private static final String DESCRIPTION = "Separate tags with ,";
    private static final int CANCEL = 0;
    private static final int FILTER = 1;
    private static final int HIGHER_RATING = 0;
    private static final int LOWER_RATING = 1;
    private static final int EXACT_RATING = 2;
    private static final int MAX = 2;
    private static final String[] RATING = new String[3];
    private JCheckBox ratingBox;
    private JCheckBox commentsBox;
    private JCheckBox tagsBox;
    private JCheckBox calendarBox;
    private JComboBox ratingOptions;
    private JXDatePicker fromDate;
    private JXDatePicker toDate;
    private RatingComponent rating;
    private JTextField tagsArea;
    private JTextField commentsArea;
    private JButton cancelButton;
    private JButton filterButton;
    private HistoryDialog tagsDialog;
    private Collection existingTags;

    private void enterTag(TagAnnotationData tag) {
        String text = tag.getTagValue();
        List<String> l = SearchUtil.splitTerms(this.tagsArea.getText(), ",");
        String result = SearchUtil.formatString(text, l);
        this.tagsArea.getDocument().removeDocumentListener(this);
        this.tagsArea.setText(result);
        this.tagsArea.getDocument().addDocumentListener(this);
    }

    private void handleTagInsert() {
        if (this.existingTags == null) {
            this.firePropertyChange(LOAD_TAG_PROPERTY, Boolean.FALSE, Boolean.TRUE);
            return;
        }
        this.codeCompletion();
        if (this.tagsDialog == null) {
            return;
        }
        String name = this.tagsArea.getText();
        String[] names = name.split(",");
        int length = names.length;
        if (length > 0) {
            if (this.tagsDialog.setSelectedTextValue(names[length - 1].trim())) {
                Rectangle r = this.tagsArea.getBounds();
                this.tagsDialog.show(this.tagsArea, 0, r.height);
                this.tagsArea.requestFocus();
            } else {
                this.tagsDialog.setVisible(false);
            }
        }
    }

    private void codeCompletion() {
        if (this.tagsDialog != null) {
            return;
        }
        Rectangle r = this.tagsArea.getBounds();
        Object[] data = null;
        if (this.existingTags != null && this.existingTags.size() > 0) {
            data = new Object[this.existingTags.size()];
            Iterator j = this.existingTags.iterator();
            int i = 0;
            while (j.hasNext()) {
                DataObject object = (DataObject)j.next();
                TagItem item = new TagItem(object);
                data[i] = item;
                ++i;
            }
            long id = MetadataViewerAgent.getUserDetails().getId();
            this.tagsDialog = new HistoryDialog(data, r.width);
            this.tagsDialog.setListCellRenderer(new TagCellRenderer(id));
            this.tagsDialog.addPropertyChangeListener("selection", this);
        }
    }

    private void setProperties() {
        this.setTitle(TITLE);
        this.setModal(true);
    }

    private void handleEnter() {
        if (this.tagsDialog == null || !this.tagsDialog.isVisible()) {
            return;
        }
        String name = this.tagsArea.getText();
        if (name == null) {
            return;
        }
        TagItem o = (TagItem)this.tagsDialog.getSelectedTextValue();
        if (o == null) {
            return;
        }
        DataObject ho = o.getDataObject();
        if (ho instanceof TagAnnotationData) {
            this.enterTag((TagAnnotationData)ho);
        }
    }

    private void initComponents() {
        this.ratingBox = new JCheckBox("Rating:");
        this.calendarBox = new JCheckBox("Calendar:");
        this.commentsBox = new JCheckBox("Comments");
        this.tagsBox = new JCheckBox("Tags");
        this.ratingOptions = new JComboBox<String>(RATING);
        this.rating = new RatingComponent(5, 0);
        this.fromDate = UIUtilities.createDatePicker(false);
        this.toDate = UIUtilities.createDatePicker(false);
        this.tagsArea = new JTextField();
        this.tagsArea.setColumns(15);
        this.tagsArea.getDocument().addDocumentListener(this);
        this.tagsArea.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                Object source = e.getSource();
                if (source != FilteringDialog.this.tagsArea) {
                    return;
                }
                switch (e.getKeyCode()) {
                    case 10: {
                        FilteringDialog.this.handleEnter();
                        break;
                    }
                    case 38: {
                        if (FilteringDialog.this.tagsDialog == null || !FilteringDialog.this.tagsDialog.isVisible()) break;
                        FilteringDialog.this.tagsDialog.setSelectedIndex(false);
                        break;
                    }
                    case 40: {
                        if (FilteringDialog.this.tagsDialog == null || !FilteringDialog.this.tagsDialog.isVisible()) break;
                        FilteringDialog.this.tagsDialog.setSelectedIndex(true);
                    }
                }
            }
        });
        this.commentsArea = new JTextField();
        this.commentsArea.setColumns(15);
        this.cancelButton = new JButton("Cancel");
        this.cancelButton.setToolTipText("Close.");
        this.cancelButton.setActionCommand("0");
        this.cancelButton.addActionListener(this);
        this.filterButton = new JButton("Filter");
        this.filterButton.setToolTipText("Filter the data.");
        this.filterButton.setActionCommand("1");
        this.filterButton.addActionListener(this);
    }

    private void filter() {
        List<String> l;
        FilterContext context = new FilterContext();
        boolean filter = false;
        if (this.ratingBox.isSelected()) {
            int index = -1;
            switch (this.ratingOptions.getSelectedIndex()) {
                case 0: {
                    index = 0;
                    break;
                }
                case 1: {
                    index = 1;
                    break;
                }
                case 2: {
                    index = 2;
                }
            }
            filter = true;
            context.setRate(index, this.rating.getCurrentValue());
        }
        if (this.calendarBox.isSelected()) {
            Date d = this.fromDate.getDate();
            Timestamp start = null;
            if (d != null) {
                start = new Timestamp(d.getTime());
            }
            Timestamp end = null;
            d = this.toDate.getDate();
            if (d != null) {
                end = new Timestamp(d.getTime());
            }
            context.setTimeInterval(start, end);
            filter = true;
        }
        if (this.tagsBox.isSelected() && (l = SearchUtil.splitTerms(this.tagsArea.getText(), ",")) != null && l.size() > 0) {
            context.addAnnotationType(TagAnnotationData.class, l);
            filter = true;
        }
        if (this.commentsBox.isSelected() && (l = SearchUtil.splitTerms(this.commentsArea.getText(), ",")) != null && l.size() > 0) {
            context.addAnnotationType(TextualAnnotationData.class, l);
            filter = true;
        }
        if (filter) {
            this.firePropertyChange(FILTER_PROPERTY, null, context);
        }
        this.setVisible(false);
    }

    private JPanel buildRatingPane() {
        JPanel p = new JPanel();
        p.add(this.ratingBox);
        p.add(this.ratingOptions);
        p.add(this.rating);
        return UIUtilities.buildComponentPanel(p, 0, 0);
    }

    private JPanel buildCalendarPane() {
        JPanel date = new JPanel();
        date.add(UIUtilities.setTextFont("From: "));
        date.add((Component)this.fromDate);
        date.add(UIUtilities.setTextFont("To: "));
        date.add((Component)this.toDate);
        JPanel p = new JPanel();
        p.setLayout(new BoxLayout(p, 0));
        p.add(this.calendarBox);
        p.add(date);
        return UIUtilities.buildComponentPanel(p, 0, 0);
    }

    public JPanel buildTagsPane() {
        JPanel p = new JPanel();
        p.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 23;
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        p.add((Component)this.tagsBox, c);
        ++c.gridx;
        p.add(Box.createHorizontalStrut(5), c);
        ++c.gridx;
        c.weightx = 0.5;
        p.add((Component)this.tagsArea, c);
        ++c.gridy;
        p.add((Component)UIUtilities.setTextFont(DESCRIPTION, 2, 10), c);
        return UIUtilities.buildComponentPanel(p, 5, 5);
    }

    public JPanel buildCommentsPane() {
        JPanel p = new JPanel();
        p.add(this.commentsBox);
        p.add(this.commentsArea);
        return UIUtilities.buildComponentPanel(p, 0, 0);
    }

    private JPanel buildSelectionPane() {
        JPanel p = new JPanel();
        double[][] size = new double[][]{{-1.0}, {-2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0, -2.0, 5.0}};
        p.setLayout((LayoutManager)new TableLayout((double[][])size));
        int i = 0;
        p.add((Component)this.buildTagsPane(), "0, " + i);
        p.add((Component)new JSeparator(0), "0, " + ++i);
        p.add((Component)this.buildCommentsPane(), "0, " + ++i);
        p.add((Component)new JSeparator(0), "0, " + ++i);
        p.add((Component)this.buildRatingPane(), "0, " + ++i);
        p.add((Component)new JSeparator(0), "0, " + ++i);
        p.add((Component)this.buildCalendarPane(), "0, " + ++i);
        p.add((Component)new JSeparator(0), "0, " + ++i);
        return p;
    }

    private JPanel buildToolBar() {
        JPanel p = new JPanel();
        p.add(this.filterButton);
        p.add(Box.createHorizontalStrut(5));
        p.add(this.cancelButton);
        return UIUtilities.buildComponentPanelRight(p);
    }

    private void buildGUI() {
        Container c = this.getContentPane();
        c.add((Component)this.buildSelectionPane(), "Center");
        c.add((Component)this.buildToolBar(), "South");
    }

    public FilteringDialog(JFrame owner) {
        super(owner);
        this.setProperties();
        this.initComponents();
        this.buildGUI();
        this.pack();
    }

    public void setTagsText(String text) {
        if (text == null) {
            return;
        }
        text = text.trim();
        this.tagsArea.getDocument().removeDocumentListener(this);
        this.tagsArea.setText(text);
        this.tagsArea.getDocument().addDocumentListener(this);
        this.tagsBox.setSelected(true);
    }

    public void setCommentsText(String text) {
        if (text == null) {
            return;
        }
        text = text.trim();
        this.commentsArea.setText(text);
        this.commentsBox.setSelected(true);
    }

    public void setRatingLevel(int value) {
        this.rating.setValue(value);
        this.ratingBox.setSelected(true);
    }

    public void setTags(Collection tags) {
        if (tags == null) {
            return;
        }
        this.existingTags = tags;
        this.codeCompletion();
    }

    public void actionPerformed(ActionEvent e) {
        int index = Integer.parseInt(e.getActionCommand());
        switch (index) {
            case 0: {
                this.setVisible(false);
                break;
            }
            case 1: {
                this.filter();
            }
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        String name = evt.getPropertyName();
        if ("selection".equals(name)) {
            Object item = evt.getNewValue();
            if (!(item instanceof TagItem)) {
                return;
            }
            DataObject ho = ((TagItem)item).getDataObject();
            if (ho instanceof TagAnnotationData) {
                this.enterTag((TagAnnotationData)ho);
            }
        }
    }

    public void insertUpdate(DocumentEvent e) {
        this.handleTagInsert();
    }

    public void removeUpdate(DocumentEvent e) {
    }

    public void changedUpdate(DocumentEvent e) {
    }

    static {
        FilteringDialog.RATING[0] = "greater or equal to";
        FilteringDialog.RATING[1] = "lower or equal to";
        FilteringDialog.RATING[2] = "equal to";
    }
}

