/*
 * Decompiled with CFR 0.152.
 */
package org.openmicroscopy.shoola.agents.dataBrowser.browser;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageNode;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.ImageSet;
import org.openmicroscopy.shoola.agents.dataBrowser.browser.WellSampleNode;
import org.openmicroscopy.shoola.util.ui.UIUtilities;
import pojos.ImageData;
import pojos.WellData;
import pojos.WellSampleData;

public class WellImageSet
extends ImageSet {
    private String rowDisplay;
    private String columnDisplay;
    private ImageNode selectedWellSample;
    private List<WellSampleNode> samples;

    private void setDefault() {
        if (this.rowDisplay == null) {
            this.setRowDisplay("" + this.getRow());
        }
        if (this.columnDisplay == null) {
            this.setColumnDisplay("" + this.getColumn());
        }
        String txt = UIUtilities.formatToolTipText(this.rowDisplay + "-" + this.columnDisplay);
        Iterator<WellSampleNode> i = this.samples.iterator();
        String title = "Well: " + this.rowDisplay + "-" + this.columnDisplay;
        while (i.hasNext()) {
            ImageNode n = i.next();
            n.setToolTipText(txt);
            n.setCanvasToolTip(txt);
            n.setTitle(title + " " + n.getTitle());
        }
    }

    public WellImageSet(WellData well) {
        super("", well);
        if (well == null) {
            throw new IllegalArgumentException("Well cannot be null.");
        }
        this.samples = new ArrayList<WellSampleNode>();
        this.setDefault();
        this.rowDisplay = null;
        this.columnDisplay = null;
    }

    public void addWellSample(WellSampleNode node) {
        if (node != null) {
            this.samples.add(node);
        }
        this.setSelectedWellSample(0);
    }

    public void setSelectedWellSample(int index) {
        for (WellSampleNode node : this.samples) {
            if (node.getIndex() != index) continue;
            this.selectedWellSample = node;
        }
    }

    public ImageNode getSelectedWellSample() {
        return this.selectedWellSample;
    }

    public ImageData getSelectedImage() {
        if (this.selectedWellSample == null) {
            return null;
        }
        WellSampleData wsd = (WellSampleData)this.selectedWellSample.getHierarchyObject();
        if (wsd == null) {
            return null;
        }
        return wsd.getImage();
    }

    public int getNumberOfSamples() {
        return this.samples.size();
    }

    public int getRow() {
        if (this.getHierarchyObject() == null) {
            return -1;
        }
        return ((WellData)this.getHierarchyObject()).getRow();
    }

    public int getColumn() {
        if (this.getHierarchyObject() == null) {
            return -1;
        }
        return ((WellData)this.getHierarchyObject()).getColumn();
    }

    public void setRowDisplay(String rowDisplay) {
        this.rowDisplay = rowDisplay;
        this.setDefault();
    }

    public void setColumnDisplay(String columnDisplay) {
        this.columnDisplay = columnDisplay;
        this.setDefault();
    }

    public void setCellDisplay(String columnDisplay, String rowDisplay) {
        this.rowDisplay = rowDisplay;
        this.columnDisplay = columnDisplay;
        this.setDefault();
    }

    public String getRowDisplay() {
        return this.rowDisplay;
    }

    public String getColumnDisplay() {
        return this.columnDisplay;
    }
}

